/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.core.model;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import cronapp.framework.core.AppConfigUtil;
import cronapp.framework.core.model.App;
import cronapp.framework.core.model.Auth;
import cronapp.framework.core.model.CronappSettings;
import cronapp.framework.core.model.Email;
import cronapp.framework.core.model.Odata;
import cronapp.framework.core.model.OpenApi;
import cronapp.framework.core.model.Security;
import cronapp.framework.core.model.ThemeConfigurationModel;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class AppConfiguration {
    public static AppConfiguration INSTANCE;
    private App app;
    private Odata odata;
    private OpenApi openApi;
    private Security security;
    private Auth auth;
    private Email email;
    private boolean fixedTimeZone = true;
    private String timeZone = "UTC";
    private Boolean showStackTrace = true;
    private String xFrameOptions = "SameOrigin";
    private String projectName;
    private Integer timeZoneOffset = 0;
    private String flushMode = "AUTO";
    private Map<String, String> libraryConfiguration = new HashMap<String, String>();
    private ThemeConfigurationModel themeConfiguration = new ThemeConfigurationModel();
    private Integer saveAuditLog = 365;

    public static AppConfiguration getInstance() {
        if (INSTANCE == null || AppConfigUtil.IS_DEBUG) {
            ClassLoader classLoader = CronappSettings.class.getClassLoader();
            ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            try (InputStream stream = classLoader.getResourceAsStream("META-INF/app.config");){
                INSTANCE = (AppConfiguration)objectMapper.readValue(stream, AppConfiguration.class);
            }
            catch (Exception e) {
                INSTANCE = new AppConfiguration();
            }
        }
        return INSTANCE;
    }

    public App getApp() {
        if (this.app == null) {
            this.app = new App();
        }
        return this.app;
    }

    public void setApp(App app) {
        this.app = app;
    }

    public Odata getOdata() {
        if (this.odata == null) {
            this.odata = new Odata();
        }
        return this.odata;
    }

    public void setOdata(Odata odata) {
        this.odata = odata;
    }

    public OpenApi getOpenApi() {
        if (this.openApi == null) {
            this.openApi = new OpenApi();
        }
        return this.openApi;
    }

    public void setOpenApi(OpenApi openApi) {
        this.openApi = openApi;
    }

    public Security getSecurity() {
        if (this.security == null) {
            this.security = new Security();
        }
        return this.security;
    }

    public void setSecurity(Security security) {
        this.security = security;
    }

    public Auth getAuth() {
        if (this.auth == null) {
            this.auth = new Auth();
        }
        return this.auth;
    }

    public void setAuth(Auth auth) {
        this.auth = auth;
    }

    public Email getEmail() {
        if (this.email == null) {
            this.email = new Email();
        }
        return this.email;
    }

    public void setEmail(Email email) {
        this.email = email;
    }

    public boolean isFixedTimeZone() {
        return this.fixedTimeZone;
    }

    public void setFixedTimeZone(boolean fixedTimeZone) {
        this.fixedTimeZone = fixedTimeZone;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        if (timeZone != null) {
            this.timeZone = timeZone;
        }
    }

    public String getXFrameOptions() {
        return this.xFrameOptions;
    }

    public void setXFrameOptions(String xFrameOptions) {
        if (xFrameOptions != null) {
            this.xFrameOptions = xFrameOptions;
        }
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        if (projectName != null) {
            this.projectName = projectName;
        }
    }

    public String getFlushMode() {
        return this.flushMode;
    }

    public void setFlushMode(String flushMode) {
        this.flushMode = flushMode;
    }

    public Boolean getShowStackTrace() {
        return this.showStackTrace == null ? true : this.showStackTrace;
    }

    public void setShowStackTrace(Boolean showStackTrace) {
        this.showStackTrace = showStackTrace;
    }

    public Integer getTimeZoneOffset() {
        return this.timeZoneOffset;
    }

    public void setTimeZoneOffset(Integer timeZoneOffset) {
        this.timeZoneOffset = timeZoneOffset;
    }

    public Map<String, String> getLibraryConfiguration() {
        return this.libraryConfiguration;
    }

    public void setLibraryConfiguration(Map<String, String> libraryConfiguration) {
        this.libraryConfiguration = libraryConfiguration;
    }

    public ThemeConfigurationModel getThemeConfiguration() {
        return Optional.ofNullable(this.themeConfiguration).orElse(new ThemeConfigurationModel());
    }

    public AppConfiguration setThemeConfiguration(ThemeConfigurationModel themeConfiguration) {
        this.themeConfiguration = themeConfiguration;
        return this;
    }

    public Integer getSaveAuditLog() {
        return this.saveAuditLog;
    }

    public void setSaveAuditLog(Integer saveAuditLog) {
        this.saveAuditLog = saveAuditLog;
    }
}

