/*
 * Decompiled with CFR 0.152.
 */
package cronapi.database;

import cronapi.database.JPAUtil;
import cronapi.database.TransactionManager;
import cronapi.i18n.Messages;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Id;
import jakarta.persistence.Query;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.eclipse.persistence.annotations.Convert;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventAdapter;

public class VersionListener
extends DescriptorEventAdapter {
    private boolean versionChecked = false;
    private List<Field> versionFields;
    private List<Field> pkFields;

    public void aboutToUpdate(DescriptorEvent event) {
        try {
            if (!this.versionChecked) {
                for (Field field : event.getObject().getClass().getDeclaredFields()) {
                    Id id;
                    Convert convert = field.getAnnotation(Convert.class);
                    if (convert != null && convert.value().equals("version")) {
                        if (this.versionFields == null) {
                            this.versionFields = new LinkedList<Field>();
                        }
                        this.versionFields.add(field);
                        field.setAccessible(true);
                    }
                    if ((id = field.getAnnotation(Id.class)) == null) continue;
                    if (this.pkFields == null) {
                        this.pkFields = new LinkedList<Field>();
                    }
                    this.pkFields.add(field);
                    field.setAccessible(true);
                }
                this.versionChecked = true;
            }
            if (this.versionChecked && this.versionFields != null && this.pkFields != null) {
                EntityManager em = TransactionManager.getEntityManager(event.getObject().getClass(), false);
                for (Field field : this.versionFields) {
                    Object newValue;
                    Object current;
                    Object value = field.get(event.getObject());
                    if (value == null) continue;
                    String jpql = "select e." + field.getName() + " from " + event.getObject().getClass().getName() + " e where ";
                    int i = 0;
                    for (Field field2 : this.pkFields) {
                        if (i > 0) {
                            jpql = jpql + " AND ";
                        }
                        jpql = jpql + "e." + field2.getName() + "  = :" + field2.getName();
                        ++i;
                    }
                    if (i > 0) {
                        jpql = jpql + " AND ";
                    }
                    jpql = jpql + "e." + field.getName() + "  = :" + field.getName();
                    ++i;
                    Query query = em.createQuery(jpql);
                    JPAUtil.prepareQuery(query);
                    for (Field pk3 : this.pkFields) {
                        Field refField = event.getObject().getClass().getDeclaredField(pk3.getName());
                        refField.setAccessible(true);
                        query.setParameter(pk3.getName(), refField.get(event.getObject()));
                    }
                    query.setParameter(field.getName(), field.get(event.getObject()));
                    query.setHint("jakarta.persistence.cache.storeMode", (Object)"REFRESH");
                    List list = query.getResultList();
                    Object v0 = current = list.size() > 0 ? list.get(0) : null;
                    if (current == null) {
                        throw new RuntimeException(Messages.getString("optimisticLockingError"));
                    }
                    Object currentValue = list.get(0);
                    if (Objects.equals(currentValue, newValue = field.get(event.getObject()))) continue;
                    throw new RuntimeException(Messages.getString("optimisticLockingError"));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

