/*
 * Decompiled with CFR 0.152.
 */
package cronapi.dashboard;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.stimulsoft.base.licenses.StiLicense;
import com.stimulsoft.report.StiOptions;
import cronapi.CronapiConfigurator;
import cronapi.dashboard.DashboardFront;
import cronapi.report.odata.StiODataDatabase;
import cronapi.report.odata.StiODataSource;
import cronapi.util.Functions;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DashboardService {
    private static HashMap<String, String> charCannotBeEscaped;
    private static final Logger log;
    private final ClassLoader loader = Thread.currentThread().getContextClassLoader();

    DashboardService() {
    }

    public DashboardFront getDashboard(String dashboardName) {
        DashboardFront dashboardFront = new DashboardFront(dashboardName);
        return dashboardFront;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String getContentDashboard(String dashboardName) {
        try (InputStream inputStream = this.getInputStream(dashboardName);){
            String string;
            try (BufferedReader buffer = new BufferedReader(new InputStreamReader(inputStream, CronapiConfigurator.ENCODING));){
                String content = buffer.lines().collect(Collectors.joining("\n"));
                JsonObject json = (JsonObject)new JsonParser().parse(content);
                json.addProperty("dashboardName", dashboardName);
                string = json.toString();
            }
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private InputStream getInputStream(String dashboardName) {
        InputStream inputStream = this.loader.getResourceAsStream(dashboardName);
        if (inputStream == null) {
            throw new RuntimeException("File [" + dashboardName + "] not found.");
        }
        return inputStream;
    }

    static {
        StiLicense.setKey((String)Functions.requirementsForReports());
        StiOptions.Services.getDataSource().add(StiODataSource.class);
        StiOptions.Services.getDataBases().add(StiODataDatabase.class);
        charCannotBeEscaped = new HashMap<String, String>(){
            {
                this.put("/", "|slash|");
            }
        };
        log = LoggerFactory.getLogger(DashboardService.class);
    }
}

