/*
 * Decompiled with CFR 0.152.
 */
package cronapi.report;

import cronapi.report.ParameterType;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.w3c.dom.Element;

public class Parameter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String description;
    private ParameterType type;
    private Object value;

    public Parameter() {
    }

    public Parameter(String name, ParameterType type, Object value) {
        this.name = name;
        this.type = type;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String name) {
        this.description = name;
    }

    public ParameterType getType() {
        return this.type;
    }

    public void setType(ParameterType type) {
        this.type = type;
    }

    public Object getValue() {
        if (this.value == null) {
            return null;
        }
        String value = this.value instanceof Element ? ((Element)this.value).getFirstChild().getNodeValue() : String.valueOf(this.value);
        switch (this.type) {
            case INTEGER: {
                return Parameter.intNotNull(value);
            }
            case DATE: {
                return Parameter.getOnlyDate(value);
            }
            case DOUBLE: {
                return Parameter.doubleNotNull(value);
            }
            case FLOAT: {
                return Parameter.floatNotNull(value);
            }
            case BOOLEAN: {
                return Parameter.booleanNotNull(value);
            }
            case LONG: {
                return Parameter.longNotNull(value);
            }
        }
        return Parameter.stringNotNull(value);
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parameter parameter = (Parameter)o;
        if (this.name != null ? !this.name.equals(parameter.name) : parameter.name != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals((Object)parameter.type) : parameter.type != null) {
            return false;
        }
        return this.value != null ? this.value.equals(parameter.value) : parameter.value == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Parameter{name='" + this.name + "', type='" + String.valueOf((Object)this.type) + "', value=" + String.valueOf(this.value) + "}";
    }

    public static Date getOnlyDate(String date) {
        return Parameter.getOnlyDate(ISODateTimeFormat.dateOptionalTimeParser().withOffsetParsed().parseLocalDateTime(date).toDate());
    }

    public static Date getOnlyDate(Date date) {
        if (date == null) {
            return null;
        }
        DateTimeZone timeZone = DateTimeZone.forID((String)"America/Sao_Paulo");
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"dd/MM/yyyy").withZone(timeZone);
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
        String dateFormated = format.format(date);
        return formatter.parseLocalDate(dateFormated).toDate();
    }

    public static boolean isExists(String value) {
        return value != null && !value.isEmpty() && !"null".equals(value);
    }

    public static Double doubleNotNull(String value) {
        if (Parameter.isExists(value)) {
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }
        return 0.0;
    }

    public static Integer intNotNull(String value) {
        if (Parameter.isExists(value)) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }

    public static Float floatNotNull(String value) {
        if (Parameter.isExists(value)) {
            try {
                return Float.valueOf(value);
            }
            catch (NumberFormatException e) {
                return Float.valueOf(0.0f);
            }
        }
        return Float.valueOf(0.0f);
    }

    public static Boolean booleanNotNull(String value) {
        if (Parameter.isExists(value)) {
            return Boolean.valueOf(value);
        }
        return Boolean.FALSE;
    }

    public static Long longNotNull(String value) {
        if (Parameter.isExists(value)) {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                return 0L;
            }
        }
        return 0L;
    }

    public static String stringNotNull(String value) {
        if (Parameter.isExists(value)) {
            return String.valueOf(value);
        }
        return "";
    }
}

