/*
 * Decompiled with CFR 0.152.
 */
package cronapi.database;

import com.fasterxml.jackson.annotation.JsonIgnore;
import cronapi.database.EntityMetadata;
import cronapi.database.FieldMetadata;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.ManagedType;
import java.util.List;

public class RelationMetadata {
    private EntityMetadata from;
    private EntityMetadata toMetadata;
    private Attribute associationAttr;
    private ManagedType association;
    private Attribute attr;
    private ManagedType to;
    private String id;

    public RelationMetadata(EntityMetadata from, Attribute attr, ManagedType to, Attribute associationAttr, ManagedType association) {
        this.from = from;
        this.associationAttr = associationAttr;
        this.association = association;
        this.attr = attr;
        this.to = to;
        this.toMetadata = new EntityMetadata(to, false);
        this.id = "relation:" + attr.getName() + ":" + to.getJavaType().getSimpleName();
    }

    @JsonIgnore
    public String getId() {
        return this.id;
    }

    @JsonIgnore
    public Attribute getAttribute() {
        return this.attr;
    }

    @JsonIgnore
    public Attribute getAssociationAttribute() {
        return this.associationAttr;
    }

    public String getLink() {
        return this.from.getFindLink() + this.id + "/";
    }

    public String getFindLink() {
        return this.getLink() + this.toMetadata.getIdLink();
    }

    public List<FieldMetadata> getFields() {
        return this.toMetadata.getFields();
    }

    public String getName() {
        return this.to.getJavaType().getCanonicalName();
    }

    public String getSimpleName() {
        return this.to.getJavaType().getSimpleName();
    }

    public String getAssossiationName() {
        return this.association != null ? this.association.getJavaType().getCanonicalName() : null;
    }

    public String gettAssossiationSimpleName() {
        return this.association != null ? this.association.getJavaType().getSimpleName() : null;
    }
}

