/*
 * Decompiled with CFR 0.152.
 */
package cronapi.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cronapi.rest.DownloadREST;
import cronapi.util.StorageServiceFileObject;
import cronapi.util.StorageServiceResult;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.springframework.web.multipart.MultipartFile;

public class StorageService {
    private static String UPLOADED_FOLDER_FULLPATH = DownloadREST.TEMP_FOLDER.getAbsolutePath();
    private ServletContext servletContext;

    public static StorageServiceResult saveUploadFiles(MultipartFile[] files) {
        String savedFiles = "";
        String name = "";
        String fileExtension = "";
        String contentType = "";
        for (MultipartFile file : files) {
            if (file.isEmpty()) continue;
            try {
                UUID uuid = UUID.randomUUID();
                String randomUUIDString = uuid.toString().replace("-", "");
                Path moveTo = Paths.get(UPLOADED_FOLDER_FULLPATH + File.separator + randomUUIDString + ".bin", new String[0]);
                file.transferTo(moveTo.toFile());
                Path metadata = Paths.get(UPLOADED_FOLDER_FULLPATH + File.separator + randomUUIDString + ".md", new String[0]);
                Files.write(metadata, StorageService.generateMetadata(file), new OpenOption[0]);
                fileExtension = "";
                if (file.getOriginalFilename().indexOf(".") > -1) {
                    fileExtension = file.getOriginalFilename().substring(file.getOriginalFilename().indexOf(".")).trim();
                }
                name = file.getOriginalFilename().replace(fileExtension, "");
                contentType = file.getContentType();
                savedFiles = String.format("%s", Paths.get(randomUUIDString + ".bin", new String[0]).toString());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        String json = String.format("{\"type\": \"tempFile\", \"path\": \"%s\", \"name\": \"%s\", \"fileExtension\": \"%s\", \"contentType\": \"%s\"}", savedFiles, name, fileExtension, contentType);
        return new StorageServiceResult(json);
    }

    private static String getFileName(Object file) {
        if (file instanceof File) {
            return ((File)file).getName();
        }
        return ((MultipartFile)file).getOriginalFilename();
    }

    private static String getFileContentType(Object file) {
        if (file instanceof File) {
            try {
                String path = ((File)file).getPath();
                return Files.probeContentType(Paths.get(path, new String[0]));
            }
            catch (Exception e) {
                return "";
            }
        }
        return ((MultipartFile)file).getContentType();
    }

    public static byte[] generateMetadata(Object file) {
        String fileExtension = "";
        String fileName = StorageService.getFileName(file);
        if (fileName.indexOf(".") > -1) {
            fileExtension = fileName.substring(fileName.indexOf(".")).trim();
        }
        String name = fileName.replace(fileExtension, "");
        String contentType = StorageService.getFileContentType(file);
        if (name.length() > 250) {
            name = name.substring(0, 250);
        }
        Object result = String.format("{\"name\":\"%s\",\"fileExtension\":\"%s\",\"contentType\":\"%s\"}", name, fileExtension, contentType);
        while (((String)result).length() < 256) {
            result = (String)result + " ";
        }
        return ((String)result).getBytes();
    }

    public static boolean isFileImage(Object file) {
        String contentFile = StorageService.getFileContentType(file);
        return contentFile.indexOf("image/") > -1;
    }

    private static JsonObject getTempFileJson(String content) {
        JsonObject tempFileJson = new JsonParser().parse(StorageService.getJsonAdjusted(content)).getAsJsonObject();
        return tempFileJson;
    }

    public static boolean isTempFileJson(String content) {
        boolean result = false;
        try {
            JsonObject tempFileJson = new JsonParser().parse(StorageService.getJsonAdjusted(content)).getAsJsonObject();
            if ("tempFile".equals(tempFileJson.get("type").getAsString())) {
                result = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public boolean deleteFile(String path) {
        try {
            return new File(path).delete();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] getFileBytesWithMetadata(String name) {
        try {
            name = StorageService.getTempFileJson(name).get("path").getAsString();
            String pathBinary = UPLOADED_FOLDER_FULLPATH + File.separator + name;
            String pathMetadata = UPLOADED_FOLDER_FULLPATH + File.separator + name.replace(".bin", ".md");
            byte[] fileBynary = Files.readAllBytes(Paths.get(pathBinary, new String[0]));
            byte[] fileMetadata = Files.readAllBytes(Paths.get(pathMetadata, new String[0]));
            byte[] bytes = new byte[fileMetadata.length + fileBynary.length];
            System.arraycopy(fileMetadata, 0, bytes, 0, fileMetadata.length);
            System.arraycopy(fileBynary, 0, bytes, fileMetadata.length, fileBynary.length);
            return bytes;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] getFileBytesWithMetadata(File file) {
        try {
            byte[] fileBynary = FileUtils.readFileToByteArray((File)file);
            byte[] fileMetadata = StorageService.generateMetadata(file);
            byte[] bytes = new byte[fileMetadata.length + fileBynary.length];
            System.arraycopy(fileMetadata, 0, bytes, 0, fileMetadata.length);
            System.arraycopy(fileBynary, 0, bytes, fileMetadata.length, fileBynary.length);
            return bytes;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] getFileBytesWithoutMetadata(String name) {
        try {
            name = StorageService.getTempFileJson(name).get("path").getAsString();
            String pathBinary = UPLOADED_FOLDER_FULLPATH + File.separator + name;
            byte[] fileBynary = Files.readAllBytes(Paths.get(pathBinary, new String[0]));
            return fileBynary;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static StorageServiceFileObject getFileObjectFromTempDirectory(String name) {
        try {
            try {
                name = StorageService.getTempFileJson(name).get("path").getAsString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String pathBinary = UPLOADED_FOLDER_FULLPATH + File.separator + name;
            String pathMetadata = UPLOADED_FOLDER_FULLPATH + File.separator + name.replace(".bin", ".md");
            byte[] fileBynary = Files.readAllBytes(Paths.get(pathBinary, new String[0]));
            byte[] fileMetadata = Files.readAllBytes(Paths.get(pathMetadata, new String[0]));
            return StorageService.generateStorageServiceFileObject(fileBynary, fileMetadata);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static StorageServiceFileObject generateStorageServiceFileObject(byte[] fileBinary, byte[] fileMetadata) {
        if (fileMetadata != null) {
            JsonObject metadata = new JsonParser().parse(StorageService.getJsonAdjusted(new String(fileMetadata))).getAsJsonObject();
            return new StorageServiceFileObject(metadata.get("name").getAsString(), metadata.get("fileExtension").getAsString(), metadata.get("contentType").getAsString(), fileBinary);
        }
        BufferedInputStream is = new BufferedInputStream(new ByteArrayInputStream(fileBinary));
        String mimeType = "";
        try {
            mimeType = URLConnection.guessContentTypeFromStream(is);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object extension = "";
        UUID uuid = UUID.randomUUID();
        String name = uuid.toString().substring(0, 6);
        if (mimeType != null && mimeType.length() > 0) {
            extension = "." + mimeType.split("/")[1];
        }
        return new StorageServiceFileObject(name, (String)extension, mimeType, fileBinary);
    }

    private static String getJsonAdjusted(String rawJson) {
        return rawJson.substring(0, rawJson.indexOf("}") + 1);
    }

    public static boolean isStorageServiceFileObject(byte[] result) {
        byte[] fileMetadata = new byte[256];
        System.arraycopy(result, 0, fileMetadata, 0, 256);
        try {
            JsonObject metadata = new JsonParser().parse(StorageService.getJsonAdjusted(new String(result))).getAsJsonObject();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static StorageServiceFileObject getFileObjectFromBytes(byte[] result) {
        try {
            if (StorageService.isStorageServiceFileObject(result)) {
                byte[] fileBytes = new byte[result.length - 256];
                System.arraycopy(result, 256, fileBytes, 0, result.length - 256);
                byte[] fileMetadata = new byte[256];
                System.arraycopy(result, 0, fileMetadata, 0, 256);
                return StorageService.generateStorageServiceFileObject(fileBytes, fileMetadata);
            }
            return StorageService.generateStorageServiceFileObject(result, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] getFileBytesMetadata(byte[] result) {
        try {
            byte[] fileMetadata = new byte[256];
            System.arraycopy(result, 0, fileMetadata, 0, 256);
            JsonObject metadata = new JsonParser().parse(StorageService.getJsonAdjusted(new String(fileMetadata))).getAsJsonObject();
            return fileMetadata;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

