/*
 * Decompiled with CFR 0.152.
 */
package cronapi.util;

import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;
import org.apache.openjpa.lib.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Functions {
    private static final Logger LOGGER = LoggerFactory.getLogger(Functions.class);

    public static List<String> parseArguments(String str) {
        return Functions.parseArguments(str, ",");
    }

    public static List<String> parseArguments(String str, String delimiters) {
        String delims = delimiters;
        String quots = "'\"[]";
        String trim = " \n\r\t";
        int currentQuot = 39;
        Object token = "";
        boolean isQuoted = false;
        LinkedList<String> tokens = new LinkedList<String>();
        for (int i = 0; i < str.length(); ++i) {
            if ("'\"[]".indexOf(str.charAt(i)) != -1 && (i == 0 || i > 0 && str.charAt(i - 1) != '\\') && (((String)token).length() == 0 || currentQuot == str.charAt(i))) {
                isQuoted = ((String)token).length() == 0;
                currentQuot = str.charAt(i);
                if (currentQuot == 91) {
                    currentQuot = 93;
                }
            }
            if (delims.indexOf(str.charAt(i)) == -1 || isQuoted) {
                if (((String)token).isEmpty() && " \n\r\t".indexOf(str.charAt(i)) != -1) continue;
                token = (String)token + str.charAt(i);
                continue;
            }
            if (!((String)token).trim().isEmpty()) {
                tokens.add(((String)token).trim());
            }
            token = "";
            isQuoted = false;
        }
        if (((String)token).trim().length() > 0) {
            tokens.add(((String)token).trim());
        }
        return tokens;
    }

    public static List<String> parseTokens(String text) {
        String delims = " \n\r\t.(){},+/?=&";
        String quots = "'";
        Object token = "";
        boolean isQuoted = false;
        ArrayList<String> tokens = new ArrayList<String>();
        for (int i = 0; i < text.length(); ++i) {
            if ("'".indexOf(text.charAt(i)) != -1) {
                boolean bl = isQuoted = ((String)token).length() == 0;
            }
            if (" \n\r\t.(){},+/?=&".indexOf(text.charAt(i)) == -1 || isQuoted) {
                token = (String)token + text.charAt(i);
                continue;
            }
            if (((String)token).length() <= 0) continue;
            tokens.add((String)token);
            token = "";
            isQuoted = false;
        }
        if (((String)token).length() > 0) {
            tokens.add((String)token);
        }
        return tokens;
    }

    public static String unquote(String str) {
        if (str.length() >= 2 && (str.startsWith("\"") || str.startsWith("'")) && (str.endsWith("\"") || str.endsWith("'"))) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static boolean isValidIdentifier(String str) {
        if (StringUtil.isEmpty((String)str)) {
            return false;
        }
        if (!(str.charAt(0) >= 'a' && str.charAt(0) <= 'z' || str.charAt(0) >= 'A' && str.charAt(0) <= 'Z' || str.charAt(0) == '_')) {
            return false;
        }
        for (int i = 1; i < str.length(); ++i) {
            if (str.charAt(i) >= 'a' && str.charAt(i) <= 'z' || str.charAt(i) >= 'A' && str.charAt(i) <= 'Z' || str.charAt(i) >= '0' && str.charAt(i) <= '9' || str.charAt(i) == '_') continue;
            return false;
        }
        return true;
    }

    public static boolean isExists(String value) {
        return value != null && !value.isEmpty();
    }

    public static byte[] getFromBase64(String base64) {
        byte[] bytes = new byte[]{};
        if (Functions.isExists(base64)) {
            bytes = Base64.getDecoder().decode(base64);
        }
        return bytes;
    }

    public static String decrypt(String encodedMessage, String key) {
        if (!Functions.isExists(encodedMessage)) {
            return null;
        }
        try {
            String newMessage = new String(Functions.getFromBase64(encodedMessage));
            char[] charMessage = new char[newMessage.length()];
            for (int index = 0; index < newMessage.length(); ++index) {
                charMessage[index] = (char)(newMessage.charAt(index) ^ key.charAt((index * 3 + 17) % key.length()));
            }
            return new String(charMessage, 0, charMessage.length);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String requirementsForReports() {
        return Functions.decrypt("cBN3GwM6eBYKHw80CjhdDSswaQEsHUU0CSxJFwA5Xhg/CWwJFS11FS8tUUcpCAwDP05wACh2eTA2TlMRLwpCb3QfZDINGh8+NhZlPxMHRjEpMmg4CDtmF3RWcyAjdkQTMDxVRTAMW24BSmcRIRxEIhFVbkU0GQMVAA4KAyt2djEtEUQybzh8LiA3dioCD3tuDk5MHA94fhgqN18iLgFAFX8TeRQgLX08LSl0FSw5RjgXDUsbPS9+FygOWhJzHUUQdAYMS3VhRSkBXA0qLzZTHG0KCEFxCAJtPEp8AXQ7dxMpHwsmIytWNCAjZUdwKlIodQ4ORDAiYi0hIHYHDAJ9AC4dTSYgKlkyLlQNGT54eDcLFXIAMSN+LignaAsFAHYvMA1fKzMYQik1LGQLCA9VNjIUZBB9CkIxIQBJORU6XTQlVw4JHj4MazwgBDdrHVJjKj1VODF4WyoqLU4iEhtmHhAmCxQeZV8/PwBUOyYHAh4LXUUVdRpiaAQPcEASex8ZdFZeChV3cmkgI2g+ayJ5CjIKBDAeN34AEghMISo8VzEJSlkHFXYMC3QgbjAVFkUUCSd4FXQ8eGMsCXcfEwJEEWk/cQQnGkE+DzZxQi4ZARQiUgU6IhZGa3IAVwJ1dkM0DTxqAB0Deyt0NllCMXlXGDAPSUQmGmwsLT9NEXICXyM3CVpBMgV6NB8GWRV3JXYJFVwJFSwMcjkOLmwAEB1FbQBWUxkVHGcpNz1yQhA0QWJpJn8BBj9McWkOChIrOQYeAFFrEjR+ZBwISg9cIn5jHSEJTxwDJgIsAA4SKwJ+QhJzA2cFNgpTdQMBWkIdNHoiDhByJQ4EbjILVnQfdX9RMxcAVyV2AA0MciltG3UBBAkjF1oadT5WcQ83UTo+DWMTB04FKT0lXisoXAo8MAgfNT4zSzoeKmwILSxqNiV+BB8rEHcGKCRkGQVQTTgJA3ArLQxFBBY5CWc=", "KzsnKD8iNXI4TlZUcFV6eg==");
    }
}

