/*
 * Decompiled with CFR 0.152.
 */
package cronapi.odata.server;

import cronapi.database.TransactionManager;
import cronapi.odata.server.JPAODataServiceFactory;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.olingo.odata2.core.servlet.ODataServlet;
import org.apache.olingo.odata2.jpa.processor.core.ODataExpressionParser;
import org.apache.olingo.odata2.jpa.processor.core.ODataParameterizedWhereExpressionUtil;

class ODataServletV2
extends ODataServlet {
    public static ThreadLocal<HttpServletRequest> REQUEST = new ThreadLocal();
    public static ThreadLocal<HttpServletResponse> RESPONSE = new ThreadLocal();
    private static final long serialVersionUID = 1L;
    private final String namespace;
    private final int order;

    public ODataServletV2(String namespace, int order) {
        this.namespace = namespace;
        this.order = order;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse res) throws IOException {
        try {
            REQUEST.set(req);
            RESPONSE.set(res);
            req.setAttribute("org.apache.olingo.odata2.service.factory.instance", (Object)new JPAODataServiceFactory(this.namespace, this.order));
            try {
                super.service(req, res);
                TransactionManager.commit();
            }
            catch (Exception e) {
                TransactionManager.rollback();
                throw e;
            }
        }
        finally {
            ODataParameterizedWhereExpressionUtil.clear();
            ODataExpressionParser.clear();
            TransactionManager.close();
            TransactionManager.clear();
            REQUEST.set(null);
            REQUEST.remove();
            RESPONSE.set(null);
            RESPONSE.remove();
        }
    }
}

