/*
 * Decompiled with CFR 0.152.
 */
package cronapi.ftp;

import cronapi.CronapiMetaData;
import cronapi.Var;
import cronapi.i18n.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class Operations {
    @CronapiMetaData(type="function", name="{{openFTPConnection}}", nameTags={"openFTPConnection", "ftpConnect", "openFtpConn"}, description="{{functionToOpenFTPConnection}}", params={"{{hostAddress}}", "{{hostPort}}", "{{login}}", "{{password}}"}, paramsType={CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.LONG, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.OBJECT)
    public static final Var openFTPConnection(Var hostAddress, Var hostPort, Var login, Var password) throws Exception {
        FTPClient ftp = new FTPClient();
        ftp.connect(hostAddress.getObjectAsString(), hostPort.getObjectAsInt().intValue());
        int reply = ftp.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            ftp.disconnect();
            throw new Exception(Messages.getString("ftpServerRefusedConnection"));
        }
        if (!ftp.login(login.getObjectAsString().trim(), password.getObjectAsString())) {
            ftp.disconnect();
            throw new Exception(Messages.getString("loginPasswordInvalid"));
        }
        return new Var(ftp);
    }

    @CronapiMetaData(type="function", name="{{closeFTPConnection}}", nameTags={"closeFTPConnection", "closeFtpConn"}, description="{{functionToCloseFTPConnection}}", params={"{{ftpConnectionObj}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT}, returnType=CronapiMetaData.ObjectType.VOID)
    public static final void closeFTPConnection(Var ftpConnectionVar) throws Exception {
        FTPClient ftp = (FTPClient)ftpConnectionVar.getObject();
        ftp.logout();
        ftp.disconnect();
    }

    @CronapiMetaData(type="function", name="{{setPassiveModeFTP}}", nameTags={"passiveModeFTP", "setPassiveModeFtp"}, description="{{functionToSetPassiveModeFTP}}", params={"{{ftpConnectionObj}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT}, returnType=CronapiMetaData.ObjectType.VOID)
    public static final void setPassiveModeFTP(Var ftpConnectionVar) throws Exception {
        FTPClient ftp = (FTPClient)ftpConnectionVar.getObject();
        ftp.enterRemotePassiveMode();
    }

    @CronapiMetaData(type="function", name="{{sendFTPCommand}}", nameTags={"sendFTPCommand"}, description="{{functionToSendFTPCommand}}", params={"{{ftpConnectionObj}}", "{{commandFtp}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT, CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.VOID)
    public static final void sendFTPCommand(Var ftpConnectionVar, Var commandFtp) throws Exception {
        FTPClient ftp = (FTPClient)ftpConnectionVar.getObject();
        ftp.sendCommand(commandFtp.getObjectAsString().trim());
    }

    @CronapiMetaData(type="function", name="{{getCurrentWorkingDirectoryFTP}}", nameTags={"getCurrentWorkingDirectoryFTP"}, description="{{functionToGetCurrentWorkingDirectoryFTP}}", params={"{{ftpConnectionObj}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT}, returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var getCurrentWorkingDirectoryFTP(Var ftpConnectionVar) throws Exception {
        FTPClient ftp = (FTPClient)ftpConnectionVar.getObject();
        return new Var(ftp.printWorkingDirectory());
    }

    @CronapiMetaData(type="function", name="{{listFTPFiles}}", nameTags={"listFTPFiles"}, description="{{functionToListFTPFiles}}", params={"{{ftpConnectionObj}}", "{{withDetail}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT, CronapiMetaData.ObjectType.BOOLEAN}, returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var listFTPFiles(Var ftpConnectionVar, Var withDetail) throws Exception {
        FTPClient ftp = (FTPClient)ftpConnectionVar.getObject();
        StringBuilder sb = new StringBuilder();
        if (withDetail.getObjectAsBoolean().booleanValue()) {
            for (FTPFile object : ftp.listFiles()) {
                sb.append(object).append("\n");
            }
        } else {
            for (String object : ftp.listNames()) {
                sb.append((Object)object).append("\n");
            }
        }
        return new Var(sb.toString());
    }

    @CronapiMetaData(type="function", name="{{listFTPFilesFromFolder}}", nameTags={"listFTPFilesFromFolder"}, description="{{functionToListFTPFilesFromFolder}}", params={"{{ftpConnectionObj}}", "{{folder}}", "{{withDetail}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.BOOLEAN}, returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var listFTPFilesFromFolder(Var ftpConnectionVar, Var folder, Var withDetail) throws Exception {
        FTPClient ftp = (FTPClient)ftpConnectionVar.getObject();
        StringBuilder sb = new StringBuilder();
        String currentDir = ftp.printWorkingDirectory();
        ftp.changeWorkingDirectory(folder.getObjectAsString().trim());
        if (withDetail.getObjectAsBoolean().booleanValue()) {
            for (FTPFile object : ftp.listFiles()) {
                sb.append(object).append("\n");
            }
        } else {
            for (String object : ftp.listNames()) {
                sb.append((Object)object).append("\n");
            }
        }
        ftp.changeWorkingDirectory(currentDir);
        return new Var(sb.toString());
    }

    @CronapiMetaData(type="function", name="{{changeFTPFolder}}", nameTags={"changeFTPFolder"}, description="{{functionToChangeFTPFolder}}", params={"{{ftpConnectionObj}}", "{{folder}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT, CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.VOID)
    public static final void changeFTPFolder(Var ftpConnectionVar, Var folder) throws Exception {
        FTPClient ftp = (FTPClient)ftpConnectionVar.getObject();
        ftp.changeWorkingDirectory(folder.getObjectAsString().trim());
    }

    @CronapiMetaData(type="function", name="{{changeToParentFTPFolder}}", nameTags={"changeToParentFTPFolder"}, description="{{functionToChangeToParentFTPFolder}}", params={"{{ftpConnectionObj}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT}, returnType=CronapiMetaData.ObjectType.VOID)
    public static final void changeToParentFTPFolder(Var ftpConnectionVar) throws Exception {
        FTPClient ftp = (FTPClient)ftpConnectionVar.getObject();
        ftp.changeToParentDirectory();
    }

    @CronapiMetaData(type="function", name="{{deleteFTPFolder}}", nameTags={"deleteFTPFolder"}, description="{{functionToDeleteFTPFolder}}", params={"{{ftpConnectionObj}}", "{{folder}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT, CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.VOID)
    public static final void deleteFTPFolder(Var ftpConnectionVar, Var folder) throws Exception {
        FTPClient ftp = (FTPClient)ftpConnectionVar.getObject();
        ftp.removeDirectory(folder.getObjectAsString().trim());
    }

    @CronapiMetaData(type="function", name="{{deleteFTPFile}}", nameTags={"deleteFTPFile"}, description="{{functionToDeleteFTPFile}}", params={"{{ftpConnectionObj}}", "{{file}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT, CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.VOID)
    public static final void deleteFTPFile(Var ftpConnectionVar, Var file) throws Exception {
        FTPClient ftp = (FTPClient)ftpConnectionVar.getObject();
        ftp.deleteFile(file.getObjectAsString().trim());
    }

    @CronapiMetaData(type="function", name="{{createNewFTPFolder}}", nameTags={"createNewFTPFolder"}, description="{{functionToCreateNewFTPFolder}}", params={"{{ftpConnectionObj}}", "{{folder}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT, CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.VOID)
    public static final void createNewFTPFolder(Var ftpConnectionVar, Var folder) throws Exception {
        FTPClient ftp = (FTPClient)ftpConnectionVar.getObject();
        ftp.makeDirectory(folder.getObjectAsString().trim());
    }

    @CronapiMetaData(type="function", name="{{uploadFileToFTP}}", nameTags={"uploadFileToFTP"}, description="{{functionToUploadFileToFTP}}", params={"{{ftpConnectionObj}}", "{{pathOfFile}}", "{{pathOfFolderFTP}}", "{{isBinaryFile}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.BOOLEAN}, returnType=CronapiMetaData.ObjectType.VOID)
    public static final void uploadFileToFTP(Var ftpConnectionVar, Var pathFile, Var ftpFolder, Var isBinaryFile) throws Exception {
        FTPClient ftp = (FTPClient)ftpConnectionVar.getObject();
        FileInputStream in = new FileInputStream(pathFile.getObjectAsString().trim());
        ftp.setFileType(isBinaryFile.getObjectAsBoolean() != false ? 2 : 0);
        ftp.storeFile(ftpFolder.getObjectAsString().trim(), (InputStream)in);
        ((InputStream)in).close();
    }

    @CronapiMetaData(type="function", name="{{downloadFileFromFTP}}", nameTags={"downloadFileFromFTP"}, description="{{functionToDownloadFileFromFTP}}", params={"{{ftpConnectionObj}}", "{{saveFileInPath}}", "{{fileToDownloadFTPPath}}", "{{isBinaryFile}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.BOOLEAN}, returnType=CronapiMetaData.ObjectType.VOID)
    public static final void downloadFileFromFTP(Var ftpConnectionVar, Var saveFileInPath, Var fileToDownloadFTPPath, Var isBinaryFile) throws Exception {
        FTPClient ftp = (FTPClient)ftpConnectionVar.getObject();
        ftp.setFileType(isBinaryFile.getObjectAsBoolean() != false ? 2 : 0);
        FileOutputStream fileDownloaded = new FileOutputStream(saveFileInPath.getObjectAsString().trim());
        if (!ftp.retrieveFile(fileToDownloadFTPPath.getObjectAsString(), (OutputStream)fileDownloaded)) {
            ((OutputStream)fileDownloaded).close();
            new File(saveFileInPath.getObjectAsString().trim()).delete();
            throw new Exception(Messages.getString("errorDownloadFile"));
        }
        ((OutputStream)fileDownloaded).close();
    }
}

