/*
 * Decompiled with CFR 0.152.
 */
package cronapi.rest;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cronapi.ClientCommand;
import cronapi.ErrorResponse;
import cronapi.RestClient;
import cronapi.RestResult;
import cronapi.Var;
import cronapi.database.TenantService;
import cronapi.database.TransactionManager;
import cronapi.i18n.Messages;
import cronapi.util.Callback;
import cronapi.util.DataType;
import cronapi.util.LRUCache;
import cronapi.util.Operations;
import cronapi.util.StorageService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.odata2.core.commons.ContentType;
import org.apache.tomcat.util.http.fileupload.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/cronapi"})
public class DownloadREST {
    private static int INTERVAL = 600000;
    private static LRUCache<String, DownloadItem> DOWNLOADS = new LRUCache(1000, INTERVAL);
    private static LRUCache<String, Callback> AFTER_UPLOAD = new LRUCache(1000, INTERVAL);
    private static boolean isDebug = Operations.IS_DEBUG;
    public static SimpleDateFormat format = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US);
    public static File TEMP_FOLDER;
    private static ScheduledExecutorService executor;
    @Autowired
    private TenantService tenantService;

    public static File getTempFile(String name) {
        return new File(TEMP_FOLDER, name);
    }

    public static String getDownloadUrl(File file) {
        String id = UUID.randomUUID().toString();
        DOWNLOADS.put(id, new DownloadItem(file));
        return "api/cronapi/download/" + id;
    }

    public static String getDownloadUrl(File file, String labelForDownload) {
        String id = UUID.randomUUID().toString();
        DOWNLOADS.put(id, new DownloadItem(file, labelForDownload));
        return "api/cronapi/download/" + id;
    }

    public static String getDownloadUrl(InputStream inputStream, String labelForDownload) {
        String id = UUID.randomUUID().toString();
        DOWNLOADS.put(id, new DownloadItem(inputStream, labelForDownload));
        return "api/cronapi/download/" + id;
    }

    public static String authorizeUpload(Callback callback) {
        String id = UUID.randomUUID().toString();
        AFTER_UPLOAD.put(id, callback);
        return id;
    }

    @ExceptionHandler(value={Throwable.class})
    @ResponseBody
    ResponseEntity<ErrorResponse> handleControllerException(HttpServletRequest req, Throwable ex) {
        ex.printStackTrace();
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.INTERNAL_SERVER_ERROR.value(), ex, req.getMethod());
        return new ResponseEntity((Object)errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.POST}, value={"/upload/{id}"})
    public RestResult upload(HttpServletResponse response, HttpServletRequest request, @PathVariable(value="id") String id, @RequestParam(value="file") MultipartFile[] uploadfiles) {
        RestResult result;
        LinkedList<File> deleteFiles;
        JsonArray array;
        File uploadedFolder;
        block23: {
            if (AFTER_UPLOAD.get(id) == null) {
                throw new RuntimeException(Messages.getString("notAllowed"));
            }
            Callback callback = AFTER_UPLOAD.get(id);
            uploadedFolder = new File(TEMP_FOLDER, id);
            uploadedFolder.mkdirs();
            array = new JsonArray();
            LinkedList<Var> files = new LinkedList<Var>();
            deleteFiles = new LinkedList<File>();
            for (MultipartFile multipartFile : uploadfiles) {
                if (multipartFile.isEmpty()) continue;
                try {
                    String randomUUIDString = UUID.randomUUID().toString();
                    File moveTo = new File(uploadedFolder, multipartFile.getOriginalFilename());
                    multipartFile.transferTo(moveTo);
                    File metadata = new File(uploadedFolder, multipartFile.getName() + ".md");
                    Files.write(metadata.toPath(), StorageService.generateMetadata(multipartFile), new OpenOption[0]);
                    JsonObject json = new JsonObject();
                    json.addProperty("name", multipartFile.getName());
                    json.addProperty("id", randomUUIDString);
                    json.addProperty("contentType", multipartFile.getContentType());
                    json.addProperty("size", (Number)multipartFile.getSize());
                    array.add((JsonElement)json);
                    files.add(Var.valueOf(moveTo));
                    deleteFiles.add(moveTo);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (callback == null) break block23;
            try {
                result = this.runIntoTransaction(callback, Var.valueOf(files));
                result.setValue(Var.valueOf(array));
                RestResult restResult = result;
                return restResult;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        RestResult restResult = result = new RestResult(Var.valueOf(array), new LinkedList<ClientCommand>());
        return restResult;
        finally {
            for (File file : deleteFiles) {
                try {
                    file.delete();
                }
                catch (Exception exception) {}
            }
            try {
                FileUtils.deleteDirectory((File)uploadedFolder);
            }
            catch (Exception exception) {}
        }
    }

    private RestResult runIntoTransaction(Callback cb, Var param) throws Exception {
        RestClient.getRestClient().setFilteredEnabled(true);
        RestClient.getRestClient().setTenantService(this.tenantService);
        try {
            cb.call(param);
            TransactionManager.commit();
        }
        catch (Exception e) {
            TransactionManager.rollback();
            throw e;
        }
        finally {
            TransactionManager.close();
            TransactionManager.clear();
        }
        return new RestResult(Var.VAR_NULL, RestClient.getRestClient().getCommands());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.GET}, value={"/download/{id}"})
    public void download(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="id") String id) throws Exception {
        InputStream synchronization;
        DownloadItem resource = DOWNLOADS.get(id);
        if (resource == null) {
            throw new Exception("File not found!");
        }
        if (resource.file == null && resource.inputStream == null) {
            throw new Exception("File not found!");
        }
        if (resource.file != null && !resource.file.exists()) {
            throw new Exception("File not found!");
        }
        InputStream inputStream = synchronization = resource.file == null ? resource.inputStream : resource.file.getAbsolutePath().intern();
        synchronized (inputStream) {
            if (resource.file != null) {
                response.setContentType(DataType.getContentType(resource.file));
                response.setContentLength((int)resource.file.length());
            } else {
                response.setContentType(ContentType.APPLICATION_OCTET_STREAM.toContentTypeString());
            }
            if (request.getParameter("cache") != null && request.getParameter("cache").equalsIgnoreCase("false")) {
                response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
                response.setHeader("Pragma", "no-cache");
                response.setDateHeader("Expires", 0L);
            } else if (resource.file != null) {
                response.addHeader("Last-Modified", format.format(new Date(resource.file.lastModified())));
                response.addHeader("ETag", String.valueOf(Math.abs(resource.file.hashCode())));
            } else {
                response.addHeader("Last-Modified", format.format(new Date()));
                response.addHeader("ETag", String.valueOf(Math.abs(resource.inputStream.hashCode())));
            }
            response.addHeader("Connection", "Keep-Alive");
            response.addHeader("Proxy-Connection", "Keep-Alive");
            if (request.getParameter("download") == null || request.getParameter("download").isEmpty() || request.getParameter("download").equalsIgnoreCase("true")) {
                String fileName = StringUtils.isNotEmpty((CharSequence)resource.label) ? resource.label : (resource.file != null ? resource.file.getName() : id);
                response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
            }
            InputStream in = null;
            ServletOutputStream outs = null;
            byte[] read = new byte[1024];
            int total = 0;
            try {
                in = resource.inputStream == null ? new FileInputStream(resource.file) : resource.inputStream;
                outs = response.getOutputStream();
                while ((total = in.read(read)) >= 0) {
                    outs.write(read, 0, total);
                }
                outs.flush();
            }
            catch (IOException iOException) {
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    static {
        executor = new ScheduledThreadPoolExecutor(1);
        TEMP_FOLDER = new File(System.getProperty("java.io.tmpdir"), "CRONAPI_RECYCLE_FILES");
        TEMP_FOLDER.mkdirs();
        executor.scheduleAtFixedRate(() -> {
            File[] files;
            for (File file : files = TEMP_FOLDER.listFiles()) {
                try {
                    BasicFileAttributes attr = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                    long millis = System.currentTimeMillis() - attr.creationTime().toMillis();
                    if (millis <= (long)INTERVAL) continue;
                    String string = file.getAbsolutePath().intern();
                    synchronized (string) {
                        if (file.isDirectory()) {
                            FileUtils.deleteDirectory((File)file);
                        } else {
                            file.delete();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }, 0L, Math.round((double)INTERVAL / 2.0), TimeUnit.MILLISECONDS);
    }

    public static class DownloadItem {
        private final File file;
        private final InputStream inputStream;
        private final String label;

        public DownloadItem(File file, String label) {
            this.file = file;
            this.label = label;
            this.inputStream = null;
        }

        public DownloadItem(File file) {
            this.file = file;
            this.label = null;
            this.inputStream = null;
        }

        public DownloadItem(InputStream inputStream) {
            this.inputStream = inputStream;
            this.label = null;
            this.file = null;
        }

        public DownloadItem(InputStream inputStream, String label) {
            this.inputStream = inputStream;
            this.label = label;
            this.file = null;
        }
    }
}

