/*
 * Decompiled with CFR 0.152.
 */
package cronapi.odata.server;

import cronapi.AppConfig;
import cronapi.ErrorResponse;
import cronapi.RestClient;
import cronapi.database.TransactionManager;
import cronapi.odata.server.DatasourceExtension;
import cronapi.odata.server.QueryExtensionEntityListener;
import java.util.Map;
import java.util.Properties;
import javax.persistence.Persistence;
import org.apache.olingo.odata2.api.ODataService;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.provider.EdmProvider;
import org.apache.olingo.odata2.api.processor.ODataSingleProcessor;
import org.apache.olingo.odata2.api.uri.UriInfo;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAContext;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAQueryExtensionEntityListener;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAServiceFactory;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmExtension;

public class JPAODataServiceFactory
extends ODataJPAServiceFactory {
    private final String namespace;
    private final Properties propertyOverrides;
    private final int order;

    public JPAODataServiceFactory(String namespace, int order) {
        this(namespace, order, null);
    }

    public JPAODataServiceFactory(String namespace, int order, Properties propertyOverrides) {
        this.namespace = namespace;
        this.order = order;
        this.propertyOverrides = propertyOverrides;
    }

    public ODataJPAContext initializeODataJPAContext() throws ODataJPARuntimeException {
        ODataJPAContext context = this.getODataJPAContext();
        context.setEntityManagerFactory(Persistence.createEntityManagerFactory((String)this.namespace, (Map)this.propertyOverrides));
        context.setPersistenceUnitName(this.namespace);
        TransactionManager.addNamespace(this.namespace, context.getEntityManager());
        context.getEntityManager().setFlushMode(AppConfig.flushMode());
        context.setJPAEdmExtension((JPAEdmExtension)new DatasourceExtension(context, this.order));
        context.setoDataJPAQueryExtensionEntityListener((ODataJPAQueryExtensionEntityListener)new QueryExtensionEntityListener());
        return context;
    }

    public ODataService createODataSingleProcessorService(EdmProvider provider, ODataSingleProcessor processor) {
        return super.createODataSingleProcessorService(provider, processor);
    }

    public Exception handleException(Throwable throwable, UriInfo info) {
        String id = null;
        try {
            EdmEntitySet oDataEntitySet = info.getTargetEntitySet();
            EdmEntityType entityType = oDataEntitySet.getEntityType();
            id = entityType.getName();
        }
        catch (Exception oDataEntitySet) {
            // empty catch block
        }
        String msg = ErrorResponse.getExceptionMessage(throwable, RestClient.getRestClient() != null ? RestClient.getRestClient().getMethod() : "GET", id);
        return new RuntimeException(msg, throwable);
    }
}

