/*
 * Decompiled with CFR 0.152.
 */
package cronapi.cloud;

import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.WriteMode;
import com.dropbox.core.v2.sharing.GetSharedLinksResult;
import com.dropbox.core.v2.sharing.LinkMetadata;
import com.dropbox.core.v2.sharing.SharedLinkMetadata;
import cronapi.cloud.CloudService;
import cronapi.cloud.FileObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DropboxService
implements CloudService {
    private static final Logger log = LoggerFactory.getLogger(DropboxService.class);
    private final DbxClientV2 client;
    private final List<FileObject> files;

    DropboxService(DbxClientV2 client, List<FileObject> files) {
        this.client = client;
        this.files = files;
    }

    @Override
    public void upload() {
        if (this.files == null || this.files.isEmpty()) {
            log.warn("File content not found to Dropbox upload");
            return;
        }
        this.files.forEach(fileObject -> {
            try {
                FileMetadata filesX = (FileMetadata)this.client.files().uploadBuilder(fileObject.getFileName()).withMode(WriteMode.OVERWRITE).uploadAndFinish(fileObject.getFileContent());
                GetSharedLinksResult sharedResult = this.client.sharing().getSharedLinks(filesX.getPathLower());
                if (sharedResult != null && sharedResult.getLinks() != null && sharedResult.getLinks().size() > 0) {
                    fileObject.setFileDirectUrl(this.convertToDirectLink(((LinkMetadata)sharedResult.getLinks().get(0)).getUrl()));
                } else {
                    SharedLinkMetadata shared = this.client.sharing().createSharedLinkWithSettings(filesX.getPathLower());
                    fileObject.setFileDirectUrl(this.convertToDirectLink(shared.getUrl()));
                }
            }
            catch (DbxException | IOException e) {
                e.printStackTrace();
                log.error(e.getMessage());
            }
        });
    }

    private String convertToDirectLink(String url) {
        return url.replace("https://www.dropbox.com/", "https://dl.dropboxusercontent.com/");
    }

    @Override
    public void popule(Object target) {
        this.files.forEach(fileObject -> {
            try {
                String fileName = fileObject.getFileName();
                String[] strings = fileName.split("/");
                if (strings.length > 0) {
                    String fieldTarget = strings[2];
                    Field declaredField = target.getClass().getDeclaredField(fieldTarget);
                    declaredField.setAccessible(true);
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    this.client.files().downloadBuilder(fileName).download((OutputStream)outputStream);
                    declaredField.set(target, outputStream.toByteArray());
                }
            }
            catch (DbxException | IOException | IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
                log.error(e.getMessage());
            }
        });
    }

    @Override
    public void delete() {
        this.files.forEach(fileObject -> {
            try {
                this.client.files().delete(fileObject.getFileName());
            }
            catch (DbxException e) {
                e.printStackTrace();
                log.error(e.getMessage());
            }
        });
    }
}

