/*
 * Decompiled with CFR 0.152.
 */
package cronapi.report.odata;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.report.dictionary.data.DataRow;
import com.stimulsoft.report.dictionary.data.DataTable;
import cronapi.QueryManager;
import cronapi.RestClient;
import cronapi.odata.server.DatasourceExtension;
import cronapi.odata.server.JPAODataServiceFactory;
import cronapi.report.odata.StiUrl;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.olingo.odata2.api.ODataService;
import org.apache.olingo.odata2.api.ODataServiceFactory;
import org.apache.olingo.odata2.api.commons.ODataHttpMethod;
import org.apache.olingo.odata2.api.processor.ODataContext;
import org.apache.olingo.odata2.api.processor.ODataRequest;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.api.uri.PathInfo;
import org.apache.olingo.odata2.api.uri.PathSegment;
import org.apache.olingo.odata2.core.ODataContextImpl;
import org.apache.olingo.odata2.core.ODataPathSegmentImpl;
import org.apache.olingo.odata2.core.ODataRequestHandler;
import org.apache.olingo.odata2.core.PathInfoImpl;
import org.apache.olingo.odata2.core.commons.ContentType;
import org.apache.olingo.odata2.core.servlet.RestUtil;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.jpa.Archive;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

class StiODataHelper {
    private final String connectionString;

    StiODataHelper(String connectionString) {
        this.connectionString = connectionString.replace("api/cronapi/odata/v2/", "");
    }

    void fillDataTable(DataTable dataTable, String query) throws StiException {
        if (StringUtils.isEmpty((Object)this.connectionString)) {
            return;
        }
        String url = StiUrl.combine(new String[]{this.connectionString, query});
        String metadata = this.downloadODataString(url);
        if (StringUtils.isEmpty((Object)metadata)) {
            return;
        }
        this.fillXmlDataTable(dataTable, metadata);
    }

    private void fillXmlDataTable(DataTable dataTable, String metadata) throws StiException {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(new StringReader(metadata)));
            NodeList title = document.getElementsByTagName("title");
            if (title != null && title.getLength() > 0) {
                dataTable.setTableName(title.item(0).getTextContent());
            }
            NodeList entries = document.getElementsByTagName("entry");
            for (Node entry : this.nodeListToList(entries)) {
                Node elementSummary;
                Node elementProperties;
                Node elementContent = this.getContentNode(entry.getChildNodes());
                if (elementContent == null || (elementProperties = this.getPropertiesNode(elementContent.getChildNodes())) == null) continue;
                DataRow row = dataTable.NewRow();
                dataTable.addRow(row);
                Node elementTitle = entry.getAttributes().getNamedItem("title");
                if (elementTitle != null && dataTable.existColumn("Name")) {
                    row.setValue("Name", (Object)elementTitle.getTextContent());
                }
                if ((elementSummary = entry.getAttributes().getNamedItem("summary")) != null && dataTable.existColumn("Description")) {
                    row.setValue("Description", (Object)elementSummary.getTextContent());
                }
                for (Node elementProperty : this.nodeListToList(elementProperties.getChildNodes())) {
                    String columnName = elementProperty.getNodeName().replaceAll("d:", "");
                    String columnTextValue = elementProperty.getTextContent();
                    if (!dataTable.existColumn(columnName)) continue;
                    row.setValue(columnName, (Object)columnTextValue);
                }
            }
        }
        catch (Exception e) {
            throw new StiException((Throwable)e);
        }
    }

    private Node getContentNode(NodeList collection) {
        return this.nodeListToList(collection).stream().filter(node -> node.getNodeName().equals("content")).findFirst().orElse(null);
    }

    private Node getPropertiesNode(NodeList collection) {
        return this.nodeListToList(collection).stream().filter(node -> node.getNodeName().endsWith("properties")).findFirst().orElse(null);
    }

    private String normalizeQueryString(String queryString) {
        String qs = queryString;
        try {
            JsonObject jsonObject = new JsonParser().parse(queryString).getAsJsonObject();
            ArrayList<String> params = new ArrayList<String>();
            if (jsonObject.has("maxRecord")) {
                params.add("$top=".concat(jsonObject.get("maxRecord").getAsString()));
            }
            qs = String.join((CharSequence)"&", params);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return qs;
    }

    private String downloadODataString(String path) throws StiException {
        try {
            String queryString = null;
            if (path.contains("?")) {
                String[] urlParts = path.split("\\?");
                queryString = urlParts[1];
                path = urlParts[0];
                queryString = this.normalizeQueryString(queryString);
                RestClient.getRestClient().setParameters(queryString);
            } else {
                RestClient.getRestClient().setParameters("");
            }
            String[] parts = path.split("/");
            String persistenceUnit = parts[0];
            Set archives = PersistenceUnitProcessor.findPersistenceArchives();
            List persistenceUnitInfos = archives.stream().map(archive -> PersistenceUnitProcessor.getPersistenceUnits((Archive)archive, (ClassLoader)Thread.currentThread().getContextClassLoader())).flatMap(Collection::stream).filter(persistenceUnitInfo -> {
                String namespace = persistenceUnitInfo.getPersistenceUnitName();
                return persistenceUnit == null || namespace.equalsIgnoreCase(persistenceUnit);
            }).collect(Collectors.toList());
            int order = 0;
            for (SEPersistenceUnitInfo persistenceUnitInfo2 : persistenceUnitInfos) {
                String namespace = persistenceUnitInfo2.getPersistenceUnitName();
                Properties properties = persistenceUnitInfo2.getProperties();
                properties.setProperty("eclipselink.ddl-generation", "none");
                JPAODataServiceFactory serviceFactory = new JPAODataServiceFactory(namespace, order, properties);
                ++order;
                LinkedList<PathSegment> odataPathSegment = new LinkedList<PathSegment>();
                for (int i = 1; i < parts.length; ++i) {
                    odataPathSegment.add((PathSegment)new ODataPathSegmentImpl(parts[i], new LinkedHashMap()));
                }
                PathInfo pathInfo = this.buildPathInfo(odataPathSegment);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(new byte[0]);
                ODataRequest odataRequest = this.buildODataRequest(pathInfo, queryString, inputStream);
                ODataContextImpl context = new ODataContextImpl(odataRequest, (ODataServiceFactory)serviceFactory);
                ODataService oDataService = serviceFactory.createService((ODataContext)context);
                context.setService(oDataService);
                oDataService.getProcessor().setContext((ODataContext)context);
                this.setJpqlExtension(serviceFactory);
                ODataRequestHandler oDataRequestHandler = new ODataRequestHandler((ODataServiceFactory)serviceFactory, oDataService, (ODataContext)context);
                QueryManager.DISABLE_AUTH = true;
                ODataResponse odataResponse = oDataRequestHandler.handle(odataRequest);
                Object entity = odataResponse.getEntity();
                if (entity == null) continue;
                if (entity instanceof InputStream) {
                    String string = this.convert((InputStream)entity);
                    return string;
                }
                if (!(entity instanceof String)) continue;
                String string = (String)entity;
                return string;
            }
        }
        catch (Exception e) {
            throw new StiException((Throwable)e);
        }
        finally {
            QueryManager.DISABLE_AUTH = false;
        }
        return null;
    }

    private void setJpqlExtension(JPAODataServiceFactory serviceFactory) throws ODataJPARuntimeException {
        String jpql = RestClient.getRestClient().getParameter("jpql");
        boolean isNative = "true".equalsIgnoreCase(RestClient.getRestClient().getParameter("native"));
        if (jpql != null && !jpql.isEmpty()) {
            ((DatasourceExtension)serviceFactory.getODataJPAContext().getJPAEdmExtension()).jpql(jpql, isNative);
        }
    }

    private PathInfo buildPathInfo(List<PathSegment> odataPathSegment) throws URISyntaxException {
        PathInfoImpl pathInfo = new PathInfoImpl();
        pathInfo.setODataPathSegment(odataPathSegment);
        pathInfo.setServiceRoot(new URI("file:///local/"));
        pathInfo.setRequestUri(new URI("file:///local/" + pathInfo));
        return pathInfo;
    }

    private ODataRequest buildODataRequest(PathInfo pathInfo, String queryString, InputStream inputStream) {
        List acceptHeaders = RestUtil.extractAcceptHeaders((String)"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8");
        Map allQueryParameters = RestUtil.extractAllQueryParameters((String)queryString, null);
        return ODataRequest.method((ODataHttpMethod)ODataHttpMethod.GET).httpMethod("GET").contentType(ContentType.APPLICATION_OCTET_STREAM.toContentTypeString()).acceptHeaders(acceptHeaders).acceptableLanguages(Collections.singletonList(Locale.US)).pathInfo(pathInfo).allQueryParameters(allQueryParameters).requestHeaders(new HashMap()).body(inputStream).build();
    }

    private String convert(InputStream inputStream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String string = reader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    private List<Node> nodeListToList(NodeList nodeList) {
        return IntStream.range(0, nodeList.getLength()).mapToObj(nodeList::item).collect(Collectors.toList());
    }
}

