/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.providers.sonar;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.AbstractModule;
import io.codemodder.CodeChanger;
import io.codemodder.CodemodProvider;
import io.codemodder.RuleSarif;
import io.codemodder.providers.sonar.RuleHotspot;
import io.codemodder.providers.sonar.RuleIssue;
import io.codemodder.providers.sonar.SonarModule;
import io.codemodder.sonar.model.CombinedSearchIssueAndHotspotResponse;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class SonarProvider
implements CodemodProvider {
    public Set<AbstractModule> getModules(Path repository, List<Path> includedFiles, List<String> pathIncludes, List<String> pathExcludes, List<Class<? extends CodeChanger>> codemodTypes, List<RuleSarif> sarifs, List<Path> sonarJsonPaths, Path defectDojoFindingsJsonFile, Path contrastFindingsJsonPath) {
        ArrayList issues = new ArrayList();
        ArrayList hotspots = new ArrayList();
        if (sonarJsonPaths != null) {
            for (Path path : sonarJsonPaths) {
                try {
                    CombinedSearchIssueAndHotspotResponse response = (CombinedSearchIssueAndHotspotResponse)new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(path.toFile(), CombinedSearchIssueAndHotspotResponse.class);
                    if (response.getIssues() != null) {
                        issues.addAll(response.getIssues());
                    }
                    if (response.getHotspots() == null) continue;
                    hotspots.addAll(response.getHotspots());
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Problem reading Sonar JSON file", e);
                }
            }
        }
        return Set.of(new SonarModule(codemodTypes, repository, List.copyOf(issues), RuleIssue.class), new SonarModule(codemodTypes, repository, List.copyOf(hotspots), RuleHotspot.class));
    }
}

