/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.providers.sonar;

import com.github.javaparser.Range;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import io.codemodder.CodemodChange;
import io.codemodder.CodemodFileScanningResult;
import io.codemodder.CodemodInvocationContext;
import io.codemodder.CodemodReporterStrategy;
import io.codemodder.FixOnlyCodeChanger;
import io.codemodder.NodeCollector;
import io.codemodder.Position;
import io.codemodder.RegionNodeMatcher;
import io.codemodder.SourceCodeRegion;
import io.codemodder.codetf.FixedFinding;
import io.codemodder.javaparser.ChangesResult;
import io.codemodder.javaparser.JavaParserChanger;
import io.codemodder.providers.sonar.RuleFinding;
import io.codemodder.sonar.model.SonarFinding;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class SonarPluginJavaParserChanger<T extends Node, S extends SonarFinding>
extends JavaParserChanger
implements FixOnlyCodeChanger {
    protected final RuleFinding<S> ruleFinding;
    private final Class<? extends Node> nodeType;
    private final RegionNodeMatcher regionNodeMatcher;
    private final NodeCollector nodeCollector;

    protected SonarPluginJavaParserChanger(RuleFinding<S> ruleFinding, Class<? extends Node> nodeType, RegionNodeMatcher regionNodeMatcher, NodeCollector nodeCollector) {
        this.ruleFinding = Objects.requireNonNull(ruleFinding);
        this.nodeType = Objects.requireNonNull(nodeType);
        this.regionNodeMatcher = regionNodeMatcher;
        this.nodeCollector = nodeCollector;
    }

    protected SonarPluginJavaParserChanger(RuleFinding<S> ruleFinding, Class<? extends Node> nodeType) {
        this(ruleFinding, nodeType, RegionNodeMatcher.MATCHES_START, NodeCollector.ALL_FROM_TYPE);
    }

    protected SonarPluginJavaParserChanger(RuleFinding<S> ruleFinding, Class<? extends Node> nodeType, RegionNodeMatcher regionNodeMatcher, CodemodReporterStrategy codemodReporterStrategy) {
        super(codemodReporterStrategy);
        this.ruleFinding = Objects.requireNonNull(ruleFinding);
        this.nodeType = Objects.requireNonNull(nodeType);
        this.regionNodeMatcher = regionNodeMatcher;
        this.nodeCollector = NodeCollector.ALL_FROM_TYPE;
    }

    public boolean supports(Path file) {
        List<S> findings = this.ruleFinding.getResultsByPath(file);
        return super.supports(file) && findings != null && !findings.isEmpty();
    }

    public CodemodFileScanningResult visit(CodemodInvocationContext context, CompilationUnit cu) {
        List allNodes = this.nodeCollector.collectNodes(cu, this.nodeType);
        List<S> findings = this.ruleFinding.getResultsByPath(context.path());
        ArrayList<CodemodChange> codemodChanges = new ArrayList<CodemodChange>();
        for (SonarFinding sonarFinding : findings) {
            for (Node node : allNodes) {
                ChangesResult changeSuccessful;
                Range range;
                Position start = new Position(Integer.valueOf(sonarFinding.getTextRange().getStartLine()), Integer.valueOf(sonarFinding.getTextRange().getStartOffset() + 1));
                Position end = new Position(Integer.valueOf(sonarFinding.getTextRange().getEndLine()), Integer.valueOf(sonarFinding.getTextRange().getEndOffset() + 1));
                SourceCodeRegion region = new SourceCodeRegion(start, end);
                if (!this.nodeType.isAssignableFrom(node.getClass()) || !context.lineIncludesExcludes().matches(region.start().line().intValue()) || !node.getRange().isPresent() || !this.regionNodeMatcher.matches(region, range = (Range)node.getRange().get()) || !(changeSuccessful = this.onFindingFound(context, cu, node, sonarFinding)).areChangesApplied()) continue;
                codemodChanges.add(CodemodChange.from((int)region.start().line(), (List)changeSuccessful.getDependenciesRequired(), (FixedFinding)new FixedFinding(sonarFinding.getKey(), this.detectorRule())));
            }
        }
        return CodemodFileScanningResult.withOnlyChanges(codemodChanges);
    }

    protected abstract ChangesResult onFindingFound(CodemodInvocationContext var1, CompilationUnit var2, T var3, S var4);

    public String vendorName() {
        return "Sonar";
    }
}

