/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.providers.sonar;

import io.codemodder.providers.sonar.RuleFinding;
import io.codemodder.sonar.model.SonarFinding;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

abstract class DefaultRuleFinding<T extends SonarFinding>
implements RuleFinding<T> {
    private final Map<String, List<T>> findings;

    DefaultRuleFinding(List<T> sonarFindings, Path repository) {
        HashMap findingsByPath = new HashMap();
        sonarFindings.forEach(finding -> {
            Optional filename = finding.componentFileName();
            if (filename.isPresent()) {
                String fullPath = repository.resolve((String)filename.get()).toString();
                List pathFindings = findingsByPath.computeIfAbsent(fullPath, f -> new ArrayList());
                pathFindings.add(finding);
            }
        });
        this.findings = Objects.requireNonNull(findingsByPath);
    }

    @Override
    public List<T> getResultsByPath(Path path) {
        return this.findings.getOrDefault(path.toString(), List.of());
    }

    @Override
    public boolean hasResults() {
        return !this.findings.isEmpty();
    }
}

