/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.providers.sonar;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.AbstractModule;
import io.codemodder.CodeChanger;
import io.codemodder.CodemodProvider;
import io.codemodder.RuleSarif;
import io.codemodder.providers.sonar.RuleHotspot;
import io.codemodder.providers.sonar.RuleIssue;
import io.codemodder.providers.sonar.SonarModule;
import io.codemodder.sonar.model.Hotspot;
import io.codemodder.sonar.model.Issue;
import io.codemodder.sonar.model.SearchHotspotsResponse;
import io.codemodder.sonar.model.SearchIssueResponse;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class SonarProvider
implements CodemodProvider {
    public Set<AbstractModule> getModules(Path repository, List<Path> includedFiles, List<String> pathIncludes, List<String> pathExcludes, List<Class<? extends CodeChanger>> codemodTypes, List<RuleSarif> sarifs, List<Path> sonarIssuesJsonPaths, List<Path> sonarHotspotsJsonPaths, Path defectDojoFindingsJsonFile, Path contrastFindingsJsonPath) {
        List<Issue> issues = this.getIssues(sonarIssuesJsonPaths);
        List<Hotspot> hotspots = this.getHotspots(sonarHotspotsJsonPaths);
        return Set.of(new SonarModule<Issue>(codemodTypes, repository, issues, RuleIssue.class), new SonarModule<Hotspot>(codemodTypes, repository, hotspots, RuleHotspot.class));
    }

    private List<Issue> getIssues(List<Path> sonarIssuesJsonPaths) {
        List<Object> allIssues = List.of();
        if (sonarIssuesJsonPaths != null) {
            ArrayList issueResponses = new ArrayList();
            sonarIssuesJsonPaths.forEach(issuesFile -> {
                try {
                    SearchIssueResponse issueResponse = (SearchIssueResponse)new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(issuesFile.toFile(), SearchIssueResponse.class);
                    issueResponses.add(issueResponse);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Problem reading Sonar issues JSON file", e);
                }
            });
            allIssues = issueResponses.stream().flatMap(response -> response.getIssues().stream()).toList();
        }
        return allIssues;
    }

    private List<Hotspot> getHotspots(List<Path> sonarHotspotsJsonPaths) {
        List<Object> allHotspots = List.of();
        if (sonarHotspotsJsonPaths != null) {
            ArrayList hotspotsResponses = new ArrayList();
            sonarHotspotsJsonPaths.forEach(hotspotsFile -> {
                try {
                    SearchHotspotsResponse hotspotResponse = (SearchHotspotsResponse)new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(hotspotsFile.toFile(), SearchHotspotsResponse.class);
                    hotspotsResponses.add(hotspotResponse);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Problem reading Sonar hotspot JSON file", e);
                }
            });
            allHotspots = hotspotsResponses.stream().flatMap(response -> response.getHotspots().stream()).toList();
        }
        return allHotspots;
    }
}

