/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.providers.sonar;

import com.github.javaparser.Range;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import io.codemodder.CodemodChange;
import io.codemodder.CodemodInvocationContext;
import io.codemodder.CodemodReporterStrategy;
import io.codemodder.NodeCollector;
import io.codemodder.Position;
import io.codemodder.RegionNodeMatcher;
import io.codemodder.SourceCodeRegion;
import io.codemodder.javaparser.JavaParserChanger;
import io.codemodder.providers.sonar.RuleIssues;
import io.codemodder.providers.sonar.api.Issue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class SonarPluginJavaParserChanger<T extends Node>
extends JavaParserChanger {
    private final RuleIssues ruleIssues;
    private final Class<? extends Node> nodeType;
    private final RegionNodeMatcher regionNodeMatcher;
    private final NodeCollector nodeCollector;

    protected SonarPluginJavaParserChanger(RuleIssues ruleIssues, Class<? extends Node> nodeType, RegionNodeMatcher regionNodeMatcher, NodeCollector nodeCollector) {
        this.ruleIssues = Objects.requireNonNull(ruleIssues);
        this.nodeType = Objects.requireNonNull(nodeType);
        this.regionNodeMatcher = regionNodeMatcher;
        this.nodeCollector = nodeCollector;
    }

    protected SonarPluginJavaParserChanger(RuleIssues ruleIssues, Class<? extends Node> nodeType) {
        this(ruleIssues, nodeType, RegionNodeMatcher.MATCHES_START, NodeCollector.ALL_FROM_TYPE);
    }

    protected SonarPluginJavaParserChanger(RuleIssues ruleIssues, Class<? extends Node> nodeType, RegionNodeMatcher regionNodeMatcher, CodemodReporterStrategy codemodReporterStrategy) {
        super(codemodReporterStrategy);
        this.ruleIssues = Objects.requireNonNull(ruleIssues);
        this.nodeType = Objects.requireNonNull(nodeType);
        this.regionNodeMatcher = regionNodeMatcher;
        this.nodeCollector = NodeCollector.ALL_FROM_TYPE;
    }

    public List<CodemodChange> visit(CodemodInvocationContext context, CompilationUnit cu) {
        List<Issue> issues = this.ruleIssues.getResultsByPath(context.path());
        if (issues == null || issues.isEmpty()) {
            return List.of();
        }
        List allNodes = this.nodeCollector.collectNodes(cu, this.nodeType);
        ArrayList<CodemodChange> codemodChanges = new ArrayList<CodemodChange>();
        for (Issue issue : issues) {
            for (Node node : allNodes) {
                boolean changeSuccessful;
                Range range;
                Position start = new Position(Integer.valueOf(issue.getTextRange().getStartLine()), Integer.valueOf(issue.getTextRange().getStartOffset() + 1));
                Position end = new Position(Integer.valueOf(issue.getTextRange().getEndLine()), Integer.valueOf(issue.getTextRange().getEndOffset() + 1));
                SourceCodeRegion region = new SourceCodeRegion(start, end);
                if (!this.nodeType.isAssignableFrom(node.getClass()) || !context.lineIncludesExcludes().matches(region.start().line().intValue()) || !node.getRange().isPresent() || !this.regionNodeMatcher.matches(region, range = (Range)node.getRange().get()) || !(changeSuccessful = this.onIssueFound(context, cu, node, issue))) continue;
                codemodChanges.add(CodemodChange.from((int)region.start().line(), (List)this.dependenciesRequired()));
            }
        }
        return codemodChanges;
    }

    public boolean shouldRun() {
        return this.ruleIssues.hasResults();
    }

    public abstract boolean onIssueFound(CodemodInvocationContext var1, CompilationUnit var2, T var3, Issue var4);
}

