/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.providers.sonar;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.AbstractModule;
import io.codemodder.CodeChanger;
import io.codemodder.providers.sonar.DefaultRuleIssues;
import io.codemodder.providers.sonar.ProvidedSonarScan;
import io.codemodder.providers.sonar.RuleIssues;
import io.codemodder.providers.sonar.api.Issue;
import io.codemodder.providers.sonar.api.SearchIssueResponse;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

final class SonarModule
extends AbstractModule {
    private final List<Class<? extends CodeChanger>> codemodTypes;
    private final Path repository;
    private final Path issuesFile;
    private static final RuleIssues EMPTY = new DefaultRuleIssues(Map.of());

    SonarModule(List<Class<? extends CodeChanger>> codemodTypes, Path repository, Path sonarIssuesJsonFile) {
        this.codemodTypes = Objects.requireNonNull(codemodTypes);
        this.repository = Objects.requireNonNull(repository);
        this.issuesFile = sonarIssuesJsonFile;
    }

    protected void configure() {
        List<Object> allIssues = List.of();
        if (this.issuesFile != null) {
            try {
                SearchIssueResponse issueResponse = (SearchIssueResponse)new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(this.issuesFile.toFile(), SearchIssueResponse.class);
                allIssues = issueResponse.getIssues();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Problem reading Sonar issues JSON file", e);
            }
        }
        HashMap perRuleBreakdown = new HashMap();
        allIssues.forEach(issue -> {
            String rule = issue.getRule();
            List perRuleList = perRuleBreakdown.computeIfAbsent(rule, k -> new ArrayList());
            perRuleList.add(issue);
        });
        HashSet<String> packagesScanned = new HashSet<String>();
        for (Class<? extends CodeChanger> codemodType : this.codemodTypes) {
            String packageName = codemodType.getPackageName();
            if (packagesScanned.contains(packageName)) continue;
            packagesScanned.add(packageName);
            ScanResult scan = new ClassGraph().enableAllInfo().acceptPackagesNonRecursive(new String[]{packageName}).removeTemporaryFilesAfterScan().scan();
            try {
                ClassInfoList classesWithMethodAnnotation = scan.getClassesWithMethodAnnotation(Inject.class);
                List injectableClasses = classesWithMethodAnnotation.loadClasses();
                List injectableParams = injectableClasses.stream().map(Class::getDeclaredConstructors).flatMap(Arrays::stream).filter(constructor -> constructor.isAnnotationPresent(Inject.class)).map(Executable::getParameters).flatMap(Arrays::stream).toList();
                HashMap boundRuleIds = new HashMap();
                injectableParams.forEach(param -> {
                    ProvidedSonarScan annotation = param.getAnnotation(ProvidedSonarScan.class);
                    if (annotation == null) {
                        return;
                    }
                    if (!RuleIssues.class.equals(param.getType())) {
                        throw new IllegalArgumentException("can't use @ProvidedSonarScan on anything except RuleIssues (see " + param.getDeclaringExecutable().getDeclaringClass().getName() + ")");
                    }
                    String ruleId = annotation.ruleId();
                    if (boundRuleIds.containsKey(ruleId)) {
                        return;
                    }
                    List issues = (List)perRuleBreakdown.get(annotation.ruleId());
                    if (issues == null || issues.isEmpty()) {
                        this.bind(RuleIssues.class).annotatedWith((Annotation)annotation).toInstance((Object)EMPTY);
                    } else {
                        HashMap<String, List<Issue>> issuesByPath = new HashMap<String, List<Issue>>();
                        issues.forEach(issue -> {
                            Optional<String> filename = issue.componentFileName();
                            if (filename.isPresent()) {
                                String fullPath = this.repository.resolve(filename.get()).toString();
                                List pathIssues = issuesByPath.computeIfAbsent(fullPath, f -> new ArrayList());
                                pathIssues.add(issue);
                            }
                        });
                        DefaultRuleIssues ruleIssues = new DefaultRuleIssues(issuesByPath);
                        this.bind(RuleIssues.class).annotatedWith((Annotation)annotation).toInstance((Object)ruleIssues);
                        boundRuleIds.put(ruleId, true);
                    }
                });
            }
            finally {
                if (scan == null) continue;
                scan.close();
            }
        }
    }
}

