/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.xxe;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.stmt.Statement;
import io.codemodder.ast.ASTs;
import io.codemodder.remediation.RemediationStrategy;
import io.codemodder.remediation.SuccessOrReason;
import io.codemodder.remediation.xxe.XMLFixBuilder;
import java.util.Optional;

final class XMLStreamReaderIntermediateFixStrategy
implements RemediationStrategy {
    XMLStreamReaderIntermediateFixStrategy() {
    }

    @Override
    public SuccessOrReason fix(CompilationUnit cu, Node node) {
        Optional maybeCall = Optional.of(node).map(m -> {
            Expression e;
            return m instanceof Expression ? (e = (Expression)m) : null;
        }).flatMap(ASTs::isArgumentOfMethodCall);
        if (maybeCall.isEmpty()) {
            return SuccessOrReason.reason("Not a method call");
        }
        MethodCallExpr createXMLStreamReaderCall = (MethodCallExpr)maybeCall.get();
        Expression xmlStreamReaderScope = (Expression)createXMLStreamReaderCall.getScope().get();
        if (!xmlStreamReaderScope.isNameExpr()) {
            return SuccessOrReason.reason("Could not find the XMLStreamReader variable");
        }
        NameExpr xmlStreamReaderVariable = xmlStreamReaderScope.asNameExpr();
        Optional ancestorStatement = createXMLStreamReaderCall.findAncestor(new Class[]{Statement.class});
        if (ancestorStatement.isEmpty()) {
            return SuccessOrReason.reason("Could not find the statement containing the XMLStreamReader creation");
        }
        Statement stmt = (Statement)ancestorStatement.get();
        return XMLFixBuilder.addXMLInputFactoryDisablingStatement(xmlStreamReaderVariable, stmt, true);
    }
}

