/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.xxe;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.stmt.Statement;
import io.codemodder.ast.ASTs;
import io.codemodder.remediation.MatchAndFixStrategy;
import io.codemodder.remediation.SuccessOrReason;
import io.codemodder.remediation.xxe.XMLFixBuilder;
import java.util.List;
import java.util.Optional;

final class XMLInputFactoryAtNewInstanceFixStrategy
extends MatchAndFixStrategy {
    XMLInputFactoryAtNewInstanceFixStrategy() {
    }

    @Override
    public boolean match(Node node) {
        Optional<MethodCallExpr> method = ASTs.isInitializedToType(node, "newInstance", List.of("var", "XMLInputFactory"));
        if (method.isEmpty()) {
            return false;
        }
        MethodCallExpr newInstance = method.get();
        Optional scope = newInstance.getScope();
        if (scope.isEmpty()) {
            return false;
        }
        return ((Expression)scope.get()).toString().equals("XMLInputFactory");
    }

    @Override
    public SuccessOrReason fix(CompilationUnit cu, Node node) {
        MethodCallExpr newInstance = (MethodCallExpr)node;
        Optional<VariableDeclarator> initExpr = ASTs.isInitExpr((Expression)newInstance);
        if (initExpr.isEmpty()) {
            return SuccessOrReason.reason("Not an initialization expression");
        }
        VariableDeclarator xmlInputFactoryVariable = initExpr.get();
        Optional variableDeclarationStmtRef = xmlInputFactoryVariable.findAncestor(new Class[]{Statement.class});
        if (variableDeclarationStmtRef.isEmpty()) {
            return SuccessOrReason.reason("Not assigned as part of statement");
        }
        Statement stmt = (Statement)variableDeclarationStmtRef.get();
        return XMLFixBuilder.addXMLInputFactoryDisablingStatement(xmlInputFactoryVariable.getNameAsExpression(), stmt, false);
    }
}

