/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.xxe;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.stmt.Statement;
import io.codemodder.ast.ASTs;
import io.codemodder.remediation.MatchAndFixStrategy;
import io.codemodder.remediation.SuccessOrReason;
import io.codemodder.remediation.xxe.XMLFixBuilder;
import java.util.List;
import java.util.Optional;

final class SAXParserAtNewSPFixStrategy
extends MatchAndFixStrategy {
    SAXParserAtNewSPFixStrategy() {
    }

    @Override
    public boolean match(Node node) {
        return ASTs.isInitializedToType(node, "newSAXParser", List.of("SAXParser")).isPresent();
    }

    @Override
    public SuccessOrReason fix(CompilationUnit cu, Node node) {
        Optional statement;
        Expression scope;
        Optional<MethodCallExpr> maybeCall = Optional.of(node).map(n -> n instanceof MethodCallExpr ? (MethodCallExpr)n : null);
        if (maybeCall.isEmpty()) {
            return SuccessOrReason.reason("Not a method call.");
        }
        MethodCallExpr newSaxParserCall = maybeCall.get();
        Optional newSaxParserCallScope = newSaxParserCall.getScope();
        if (newSaxParserCallScope.isEmpty()) {
            SuccessOrReason.reason("No scope found");
        }
        if (!(scope = (Expression)newSaxParserCallScope.get()).isNameExpr()) {
            SuccessOrReason.reason("Scope is not a name");
        }
        if ((statement = scope.findAncestor(new Class[]{Statement.class})).isEmpty()) {
            return SuccessOrReason.reason("No statement found");
        }
        return XMLFixBuilder.addFeatureDisablingStatements(scope.asNameExpr(), (Statement)statement.get(), true);
    }
}

