/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.xss;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.MethodCallExpr;
import io.codemodder.remediation.RemediationStrategy;
import io.codemodder.remediation.SuccessOrReason;
import io.codemodder.remediation.xss.EncoderWrapping;
import java.util.Optional;
import java.util.Set;

final class PrintingMethodFixStrategy
implements RemediationStrategy {
    private static final Set<String> writingMethodNames = Set.of("print", "println", "write");

    PrintingMethodFixStrategy() {
    }

    @Override
    public SuccessOrReason fix(CompilationUnit cu, Node node) {
        Optional<MethodCallExpr> maybeCall = Optional.of(node).map(n -> n instanceof MethodCallExpr ? (MethodCallExpr)n : null);
        if (maybeCall.isEmpty()) {
            return SuccessOrReason.reason("Not a method call.");
        }
        MethodCallExpr call = maybeCall.get();
        return EncoderWrapping.fix(call, 0);
    }

    static boolean match(Node node) {
        return Optional.of(node).map(n -> n instanceof MethodCallExpr ? (MethodCallExpr)n : null).filter(mce -> writingMethodNames.contains(mce.getNameAsString())).filter(mce -> mce.getArguments().size() == 1).isPresent();
    }
}

