/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.sqlinjection;

import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.resolution.types.ResolvedType;
import io.codemodder.ast.LinearizedStringExpression;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Optional;

public final class QueryParameterizer {
    private final List<Deque<Expression>> injections;
    private final LinearizedStringExpression linearizedQuery;

    public QueryParameterizer(Expression query) {
        this.linearizedQuery = new LinearizedStringExpression(query);
        this.injections = this.gatherParameters(this.linearizedQuery.getLinearized());
    }

    public Expression getRoot() {
        return this.linearizedQuery.getRoot();
    }

    public List<Deque<Expression>> getInjections() {
        return this.injections;
    }

    public LinearizedStringExpression getLinearizedQuery() {
        return this.linearizedQuery;
    }

    private Optional<ResolvedType> calculateResolvedType(Expression e) {
        try {
            return Optional.of(e.calculateResolvedType());
        }
        catch (RuntimeException exception) {
            return Optional.empty();
        }
    }

    private List<Deque<Expression>> gatherParameters(Deque<Expression> query) {
        ArrayList<Deque<Expression>> parameters = new ArrayList<Deque<Expression>>();
        int modulo2 = 1;
        while (!query.isEmpty()) {
            Expression start = query.pop();
            while (!query.isEmpty() && !this.isStartPattern(start, modulo2)) {
                if (modulo2 == 0) {
                    modulo2 = 1;
                }
                start = query.pop();
            }
            if (query.isEmpty()) continue;
            ArrayDeque<Expression> middleExpressions = new ArrayDeque<Expression>();
            while (!query.isEmpty() && !this.isEndPattern(query.peekFirst())) {
                middleExpressions.add(query.pop());
            }
            if (query.isEmpty()) {
                return List.of();
            }
            Expression end = query.peekFirst();
            modulo2 = 0;
            if (middleExpressions.size() == 1 && !this.convertibleToString((Expression)middleExpressions.peek()) || middleExpressions.stream().allMatch(e -> e instanceof StringLiteralExpr)) continue;
            middleExpressions.addFirst(start);
            middleExpressions.add(end);
            parameters.add(middleExpressions);
        }
        return parameters;
    }

    private boolean convertibleToString(Expression exp) {
        Optional<ResolvedType> typeRef = this.calculateResolvedType(exp);
        if (typeRef.isEmpty()) {
            return true;
        }
        ResolvedType type = typeRef.get();
        if (type.isPrimitive()) {
            return false;
        }
        if (type.isArray() && (type.asArrayType().getComponentType().describe().equals("byte") || type.asArrayType().getComponentType().describe().equals("java.lang.Byte"))) {
            return false;
        }
        List<String> blacklist = List.of("java.math.BigDecimal", "java.math.BigInteger", "java.sql.Date", "java.sql.Time", "java.sql.Timestamp", "java.sql.Clob", "java.sql.Blob", "java.sql.Array", "java.sql.Struct", "java.sql.Ref", "java.sql.RowId", "java.sql.NClob", "java.sql.SQLXML", "java.util.Calendar", "java.util.Date", "java.time.LocalDate", "java.time.LocalTime", "java.time.LocalDateTime", "java.time.OffsetTime", "java.time.OffsetDateTime", "java.net.URL");
        for (String t : blacklist) {
            if (!type.describe().equals(t)) continue;
            return false;
        }
        return true;
    }

    private List<Integer> allIndexesOf(char character, String string) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        int currentIndex = string.indexOf(character);
        while (currentIndex >= 0) {
            indexes.add(currentIndex);
            currentIndex = string.indexOf(character, currentIndex + 1);
        }
        return indexes;
    }

    private boolean isStartPattern(Expression e, int modulo2) {
        if (e != null && e.isStringLiteralExpr()) {
            List<Integer> indexes = this.allIndexesOf('\'', e.asStringLiteralExpr().asString());
            return indexes.size() % 2 == modulo2;
        }
        return false;
    }

    private boolean isEndPattern(Expression e) {
        if (e != null && e.isStringLiteralExpr()) {
            return e.asStringLiteralExpr().asString().indexOf(39) >= 0;
        }
        return false;
    }
}

