/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.loginjection;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.resolution.types.ResolvedType;
import io.codemodder.DependencyGAV;
import io.codemodder.ast.ASTs;
import io.codemodder.ast.LocalDeclaration;
import io.codemodder.javaparser.JavaParserTransformer;
import io.codemodder.remediation.RemediationStrategy;
import io.codemodder.remediation.SuccessOrReason;
import io.github.pixee.security.Newlines;
import java.util.List;
import java.util.Optional;

final class LogStatementFixer
implements RemediationStrategy {
    LogStatementFixer() {
    }

    @Override
    public SuccessOrReason fix(CompilationUnit compilationUnit, Node node) {
        MethodCallExpr logCall = (MethodCallExpr)node;
        NodeList arguments = logCall.getArguments();
        return this.fixArguments((NodeList<Expression>)arguments);
    }

    private SuccessOrReason fixArguments(NodeList<Expression> arguments) {
        BinaryExpr binaryExpr;
        Optional<Expression> expressionToWrap;
        if (arguments.size() == 1 && LogStatementFixer.isNameOrMethodExpr((Expression)arguments.get(0)) || arguments.size() == 2 && LogStatementFixer.isNameOrMethodExpr((Expression)arguments.get(0)) && this.isException((Expression)arguments.get(1))) {
            Expression argument = (Expression)arguments.get(0);
            LogStatementFixer.wrapWithNewlineSanitizer(argument);
            return SuccessOrReason.success(List.of(DependencyGAV.JAVA_SECURITY_TOOLKIT));
        }
        if (arguments.size() == 2 && ((Expression)arguments.get(0)).isStringLiteralExpr() && LogStatementFixer.isNameOrMethodExpr((Expression)arguments.get(1)) || arguments.size() == 3 && ((Expression)arguments.get(0)).isStringLiteralExpr() && LogStatementFixer.isNameOrMethodExpr((Expression)arguments.get(1)) && this.isException((Expression)arguments.get(2))) {
            Expression argument = (Expression)arguments.get(1);
            LogStatementFixer.wrapWithNewlineSanitizer(argument);
            return SuccessOrReason.success(List.of(DependencyGAV.JAVA_SECURITY_TOOLKIT));
        }
        if ((arguments.size() == 2 && ((Expression)arguments.get(0)).isBinaryExpr() || arguments.size() == 3 && ((Expression)arguments.get(0)).isBinaryExpr() && this.isException((Expression)arguments.get(2))) && (expressionToWrap = LogStatementFixer.findExpressionToWrap((Expression)(binaryExpr = ((Expression)arguments.get(0)).asBinaryExpr()))).isPresent()) {
            LogStatementFixer.wrapWithNewlineSanitizer(expressionToWrap.get());
            return SuccessOrReason.success(List.of(DependencyGAV.JAVA_SECURITY_TOOLKIT));
        }
        if (arguments.size() == 1 && ((Expression)arguments.get(0)).isBinaryExpr() && (expressionToWrap = LogStatementFixer.findExpressionToWrap((Expression)(binaryExpr = ((Expression)arguments.get(0)).asBinaryExpr()))).isPresent()) {
            LogStatementFixer.wrapWithNewlineSanitizer(expressionToWrap.get());
            return SuccessOrReason.success(List.of(DependencyGAV.JAVA_SECURITY_TOOLKIT));
        }
        return SuccessOrReason.reason("Unfixable log call shape");
    }

    private static boolean isNameOrMethodExpr(Expression expression) {
        return expression.isNameExpr() || expression.isMethodCallExpr();
    }

    private boolean isException(Expression expression) {
        block7: {
            if (expression.isNameExpr()) {
                try {
                    ResolvedType type = expression.calculateResolvedType();
                    String typeName = type.describe();
                    return LogStatementFixer.isExceptionTypeName(typeName);
                }
                catch (Exception e) {
                    Optional<Node> nameSourceNodeRef;
                    Node declaration;
                    Optional<LocalDeclaration> declarationRef = ASTs.findEarliestLocalDeclarationOf((Node)expression, "ex");
                    if (declarationRef.isPresent()) {
                        LocalDeclaration localDeclaration = declarationRef.get();
                        declaration = localDeclaration.getDeclaration();
                        if (declaration instanceof Parameter) {
                            Parameter param = (Parameter)declaration;
                            String typeAsString = param.getTypeAsString();
                            return LogStatementFixer.isExceptionTypeName(typeAsString);
                        }
                        if (declaration instanceof VariableDeclarator) {
                            VariableDeclarator var = (VariableDeclarator)declaration;
                            String typeAsString = var.getTypeAsString();
                            return LogStatementFixer.isExceptionTypeName(typeAsString);
                        }
                    }
                    if (!(nameSourceNodeRef = ASTs.findNonCallableSimpleNameSource((Node)expression, "e")).isPresent()) break block7;
                    declaration = nameSourceNodeRef.get();
                    if (declaration instanceof Parameter) {
                        Parameter param = (Parameter)declaration;
                        String typeAsString = param.getTypeAsString();
                        return LogStatementFixer.isExceptionTypeName(typeAsString);
                    }
                    if (!(declaration instanceof VariableDeclarator)) break block7;
                    VariableDeclarator var = (VariableDeclarator)declaration;
                    String typeAsString = var.getTypeAsString();
                    return LogStatementFixer.isExceptionTypeName(typeAsString);
                }
            }
        }
        return false;
    }

    private static boolean isExceptionTypeName(String typeName) {
        return typeName.endsWith("Exception") || typeName.endsWith("Throwable");
    }

    private static Optional<Expression> findExpressionToWrap(Expression argument) {
        if (argument.isNameExpr()) {
            return Optional.of(argument);
        }
        if (argument.isBinaryExpr()) {
            BinaryExpr binaryExpr = argument.asBinaryExpr();
            if (binaryExpr.getLeft().isBinaryExpr() && binaryExpr.getRight().isStringLiteralExpr()) {
                BinaryExpr leftBinaryExpr = binaryExpr.getLeft().asBinaryExpr();
                if (leftBinaryExpr.getLeft().isStringLiteralExpr() && !leftBinaryExpr.getRight().isStringLiteralExpr()) {
                    return Optional.of(leftBinaryExpr.getRight());
                }
            } else {
                if (binaryExpr.getLeft().isStringLiteralExpr() && binaryExpr.getRight().isStringLiteralExpr()) {
                    return Optional.empty();
                }
                if (binaryExpr.getLeft().isStringLiteralExpr()) {
                    return Optional.of(binaryExpr.getRight());
                }
                if (binaryExpr.getRight().isStringLiteralExpr()) {
                    return Optional.of(binaryExpr.getLeft());
                }
            }
        }
        return Optional.empty();
    }

    private static void wrapWithNewlineSanitizer(Expression expression) {
        JavaParserTransformer.wrap(expression).withStaticMethod(Newlines.class.getName(), "stripAll", true);
    }
}

