/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import com.contrastsecurity.sarif.Region;
import com.contrastsecurity.sarif.Result;
import com.contrastsecurity.sarif.SarifSchema210;
import io.codemodder.RuleSarif;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import javax.inject.Provider;

public class LazyLoadingRuleSarif
implements RuleSarif {
    private RuleSarif ruleSarif = null;
    private final Provider<RuleSarif> ruleSarifProvider;

    public LazyLoadingRuleSarif(Provider<RuleSarif> ruleSarifProvider) {
        this.ruleSarifProvider = Objects.requireNonNull(ruleSarifProvider);
    }

    @Override
    public List<Region> getRegionsFromResultsByRule(Path path) {
        this.checkInitialized();
        return this.ruleSarif.getRegionsFromResultsByRule(path);
    }

    private void checkInitialized() {
        if (this.ruleSarif == null) {
            this.ruleSarif = (RuleSarif)this.ruleSarifProvider.get();
            if (this.ruleSarif == null) {
                throw new IllegalStateException("SARIF must be provided");
            }
        }
    }

    @Override
    public List<Result> getResultsByLocationPath(Path path) {
        this.checkInitialized();
        return this.ruleSarif.getResultsByLocationPath(path);
    }

    @Override
    public SarifSchema210 rawDocument() {
        this.checkInitialized();
        return this.ruleSarif.rawDocument();
    }

    @Override
    public String getRule() {
        this.checkInitialized();
        return this.ruleSarif.getRule();
    }

    @Override
    public String getDriver() {
        this.checkInitialized();
        return this.ruleSarif.getDriver();
    }
}

