/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import io.codemodder.AICodemodFileScanningResult;
import io.codemodder.CodemodChange;
import io.codemodder.codetf.CodeTFAiMetadata;
import io.codemodder.codetf.UnfixedFinding;
import java.util.List;

public interface CodemodFileScanningResult {
    public static CodemodFileScanningResult from(final List<CodemodChange> changes, final List<UnfixedFinding> unfixedFindings) {
        return new CodemodFileScanningResult(){

            @Override
            public List<CodemodChange> changes() {
                return List.copyOf(changes);
            }

            @Override
            public List<UnfixedFinding> unfixedFindings() {
                return List.copyOf(unfixedFindings);
            }
        };
    }

    public static CodemodFileScanningResult from(List<CodemodChange> changes, List<UnfixedFinding> unfixedFindings, CodeTFAiMetadata codeTFAiMetadata) {
        return new AICodemodFileScanningResult(changes, unfixedFindings, codeTFAiMetadata);
    }

    public static CodemodFileScanningResult none() {
        return CodemodFileScanningResult.from(List.of(), List.of());
    }

    public static CodemodFileScanningResult withOnlyChanges(List<CodemodChange> changes) {
        return CodemodFileScanningResult.from(changes, List.of());
    }

    public List<CodemodChange> changes();

    public List<UnfixedFinding> unfixedFindings();
}

