/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.javaparser;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import io.codemodder.ast.ASTs;
import io.codemodder.ast.LocalVariableDeclaration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ASTExpectations {
    private ASTExpectations() {
    }

    public static NodeExpectation expect(Node node) {
        return new NodeExpectation(node);
    }

    public static class NodeExpectation
    implements ASTExpectationProducer<Node> {
        private Optional<Node> nodeRef;

        public NodeExpectation(Node node) {
            this.nodeRef = Optional.of(node);
        }

        public NodeExpectation withBlockParent() {
            if (this.nodeRef.isEmpty()) {
                return this;
            }
            this.nodeRef = this.nodeRef.filter(n -> n.getParentNode().filter(parent -> parent instanceof BlockStmt).isPresent());
            return this;
        }

        public VariableDeclarationExprExpectation toBeVariableDeclarationStatement() {
            Optional<VariableDeclarationExpr> vde = this.nodeRef.map(n -> n instanceof ExpressionStmt ? (ExpressionStmt)n : null).map(ExpressionStmt::getExpression).map(expr -> expr.isVariableDeclarationExpr() ? expr.asVariableDeclarationExpr() : null);
            return new VariableDeclarationExprExpectation(vde);
        }

        public MethodCallExpectation toBeMethodCallExpression() {
            if (this.nodeRef.isEmpty() || !(this.nodeRef.get() instanceof MethodCallExpr)) {
                return new MethodCallExpectation(Optional.empty());
            }
            return new MethodCallExpectation(Optional.of((MethodCallExpr)this.nodeRef.get()));
        }

        public ExpressionStatementExpectation toBeExpressionStatement() {
            if (this.nodeRef.isEmpty() || !(this.nodeRef.get() instanceof ExpressionStmt)) {
                return new ExpressionStatementExpectation(Optional.empty());
            }
            return new ExpressionStatementExpectation(Optional.of((ExpressionStmt)this.nodeRef.get()));
        }

        public NameExpressionExpectation toBeNameExpression() {
            if (this.nodeRef.isEmpty() || !(this.nodeRef.get() instanceof NameExpr)) {
                return new NameExpressionExpectation(Optional.empty());
            }
            return new NameExpressionExpectation(Optional.of((NameExpr)this.nodeRef.get()));
        }

        public FieldAccessExpectation toBeFieldAccessExpression() {
            if (this.nodeRef.isEmpty() || !(this.nodeRef.get() instanceof FieldAccessExpr)) {
                return new FieldAccessExpectation(Optional.empty());
            }
            return new FieldAccessExpectation(Optional.of((FieldAccessExpr)this.nodeRef.get()));
        }

        public StringLiteralExpectation toBeStringLiteral() {
            if (this.nodeRef.isEmpty() || !(this.nodeRef.get() instanceof StringLiteralExpr)) {
                return new StringLiteralExpectation(Optional.empty());
            }
            return new StringLiteralExpectation(Optional.of((StringLiteralExpr)this.nodeRef.get()));
        }

        @Override
        public Optional<Node> result() {
            return this.nodeRef;
        }
    }

    public static class MethodCallExpectation
    implements ASTExpectationProducer<MethodCallExpr> {
        private Optional<MethodCallExpr> methodCallExpr;

        public MethodCallExpectation(Optional<MethodCallExpr> methodCallExpr) {
            this.methodCallExpr = Objects.requireNonNull(methodCallExpr);
        }

        @Override
        public Optional<MethodCallExpr> result() {
            return this.methodCallExpr;
        }

        public MethodCallExpectation withArgumentsSize(int expectedSize) {
            if (this.methodCallExpr.isEmpty()) {
                return this;
            }
            MethodCallExpr callExpr = this.methodCallExpr.get();
            if (callExpr.getArguments().size() != expectedSize) {
                this.methodCallExpr = Optional.empty();
            }
            return this;
        }

        public MethodCallExpectation withName(String expectedName) {
            if (this.methodCallExpr.isEmpty()) {
                return this;
            }
            MethodCallExpr callExpr = this.methodCallExpr.get();
            if (!expectedName.equals(callExpr.getNameAsString())) {
                this.methodCallExpr = Optional.empty();
            }
            return this;
        }

        public MethodCallExpectation withArguments() {
            if (this.methodCallExpr.isEmpty()) {
                return this;
            }
            MethodCallExpr callExpr = this.methodCallExpr.get();
            if (callExpr.getArguments().isEmpty()) {
                this.methodCallExpr = Optional.empty();
            }
            return this;
        }
    }

    public static class LocalVariableDeclaratorExpectation
    implements ASTExpectationProducer<VariableDeclarator> {
        private Optional<VariableDeclarator> varRef;

        public LocalVariableDeclaratorExpectation(Optional<VariableDeclarator> variableDeclarator) {
            this.varRef = Objects.requireNonNull(variableDeclarator);
        }

        public LocalVariableDeclaratorExpectation withDirectReferenceCount(int count) {
            if (this.varRef.isEmpty()) {
                return this;
            }
            Optional<LocalVariableDeclaration> localVariableDeclaration = LocalVariableDeclaration.fromVariableDeclarator(this.varRef.get());
            if (localVariableDeclaration.isEmpty()) {
                this.varRef = Optional.empty();
                return this;
            }
            List<NameExpr> allReferences = ASTs.findAllReferences(localVariableDeclaration.get());
            if (allReferences.size() != count) {
                this.varRef = Optional.empty();
            }
            return this;
        }

        public MethodCallExpectation toBeInitializedByMethodCall() {
            if (this.varRef.isEmpty()) {
                return new MethodCallExpectation(Optional.empty());
            }
            Optional<MethodCallExpr> mc = this.varRef.flatMap(VariableDeclarator::getInitializer).filter(MethodCallExpr.class::isInstance).map(MethodCallExpr.class::cast);
            if (mc.isEmpty()) {
                this.varRef = Optional.empty();
            }
            return new MethodCallExpectation(mc);
        }

        @Override
        public Optional<VariableDeclarator> result() {
            return this.varRef;
        }
    }

    public static class VariableDeclarationExprExpectation
    implements ASTExpectationProducer<VariableDeclarationExpr> {
        private Optional<VariableDeclarationExpr> varDefExprRef;

        private VariableDeclarationExprExpectation(Optional<VariableDeclarationExpr> expr) {
            this.varDefExprRef = expr;
        }

        public LocalVariableDeclaratorExpectation toBeSingleLocalVariableDefinition() {
            if (this.varDefExprRef.isEmpty()) {
                return new LocalVariableDeclaratorExpectation(Optional.empty());
            }
            VariableDeclarationExpr variableDeclarationExpr = this.varDefExprRef.get();
            if (variableDeclarationExpr.getVariables().size() != 1) {
                this.varDefExprRef = Optional.empty();
                return new LocalVariableDeclaratorExpectation(Optional.empty());
            }
            Optional<LocalVariableDeclaration> localVariableDeclaration = LocalVariableDeclaration.fromVariableDeclarator(variableDeclarationExpr.getVariable(0));
            if (localVariableDeclaration.isPresent()) {
                return new LocalVariableDeclaratorExpectation(Optional.of((VariableDeclarator)variableDeclarationExpr.getVariables().get(0)));
            }
            return new LocalVariableDeclaratorExpectation(Optional.empty());
        }

        @Override
        public Optional<VariableDeclarationExpr> result() {
            return this.varDefExprRef;
        }
    }

    public static class ExpressionStatementExpectation
    implements ASTExpectationProducer<ExpressionStmt> {
        private final Optional<ExpressionStmt> expressionStmtRef;

        private ExpressionStatementExpectation(Optional<ExpressionStmt> expr) {
            this.expressionStmtRef = expr;
        }

        @Override
        public Optional<ExpressionStmt> result() {
            return this.expressionStmtRef;
        }

        public LocalVariableDeclaratorExpectation withSingleVariableDeclarationExpression() {
            VariableDeclarationExpr declarationExpr;
            if (this.expressionStmtRef.isEmpty()) {
                return new LocalVariableDeclaratorExpectation(Optional.empty());
            }
            ExpressionStmt expressionStmt = this.expressionStmtRef.get();
            if (expressionStmt.getExpression() instanceof VariableDeclarationExpr && (declarationExpr = expressionStmt.getExpression().asVariableDeclarationExpr()).getVariables().size() == 1) {
                return new LocalVariableDeclaratorExpectation(Optional.of(declarationExpr.getVariable(0)));
            }
            return new LocalVariableDeclaratorExpectation(Optional.empty());
        }

        public MethodCallExpectation withMethodCallExpression() {
            ExpressionStmt expressionStmt;
            if (this.expressionStmtRef.isPresent() && (expressionStmt = this.expressionStmtRef.get()).getExpression() instanceof MethodCallExpr) {
                return new MethodCallExpectation(Optional.of(expressionStmt.getExpression().asMethodCallExpr()));
            }
            return new MethodCallExpectation(Optional.empty());
        }
    }

    public static class StringLiteralExpectation
    implements ASTExpectationProducer<StringLiteralExpr> {
        private final Optional<StringLiteralExpr> stringLiteralExpr;

        public StringLiteralExpectation(Optional<StringLiteralExpr> stringLiteralExpr) {
            this.stringLiteralExpr = stringLiteralExpr;
        }

        @Override
        public Optional<StringLiteralExpr> result() {
            return this.stringLiteralExpr;
        }
    }

    public static class NameExpressionExpectation
    implements ASTExpectationProducer<NameExpr> {
        private final Optional<NameExpr> name;

        private NameExpressionExpectation(Optional<NameExpr> name) {
            this.name = Objects.requireNonNull(name);
        }

        @Override
        public Optional<NameExpr> result() {
            return this.name;
        }
    }

    public static class FieldAccessExpectation
    implements ASTExpectationProducer<FieldAccessExpr> {
        private final Optional<FieldAccessExpr> name;

        private FieldAccessExpectation(Optional<FieldAccessExpr> name) {
            this.name = Objects.requireNonNull(name);
        }

        @Override
        public Optional<FieldAccessExpr> result() {
            return this.name;
        }
    }

    static interface ASTExpectationProducer<T extends Node> {
        public Optional<T> result();
    }
}

