/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.ast;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ForEachStmt;
import com.github.javaparser.ast.stmt.ForStmt;
import com.github.javaparser.ast.stmt.TryStmt;
import io.codemodder.ast.ASTs;
import io.codemodder.ast.ExpressionStmtVariableDeclaration;
import io.codemodder.ast.ForEachDeclaration;
import io.codemodder.ast.ForInitDeclaration;
import io.codemodder.ast.LocalDeclaration;
import io.codemodder.ast.LocalVariableDeclaration;
import io.codemodder.ast.ParameterDeclaration;
import io.codemodder.ast.TryResourceDeclaration;
import java.util.Optional;
import org.javatuples.Pair;
import org.javatuples.Triplet;

final class NameResolver {
    NameResolver() {
    }

    private static Optional<Node> isLocalNameSource(Node n, String name) {
        Optional<Node> maybe = ASTs.isExpressionStmtDeclarationOf(n, name).map(Triplet::getValue2);
        return maybe.or(() -> ASTs.isResourceOf(n, name).map(Triplet::getValue2)).or(() -> ASTs.isForVariableDeclarationOf(n, name).map(Triplet::getValue2)).or(() -> ASTs.isForEachVariableDeclarationOf(n, name).map(Triplet::getValue2)).or(() -> ASTs.isLambdaExprParameterOf(n, name).map(Pair::getValue1)).or(() -> ASTs.isExceptionParameterOf(n, name).map(Pair::getValue1)).or(() -> ASTs.isMethodFormalParameterOf(n, name).map(Pair::getValue1)).or(() -> ASTs.isMethodTypeParameterOf(n, name).map(Pair::getValue1)).or(() -> ASTs.isConstructorFormalParameterOf(n, name).map(Pair::getValue1)).or(() -> ASTs.isConstructorTypeParameterOf(n, name).map(Pair::getValue1)).or(() -> ASTs.isLocalTypeDeclarationOf(n, name).map(Pair::getValue1)).or(() -> ASTs.isLocalRecordDeclarationOf(n, name).map(Pair::getValue1)).or(() -> ASTs.isPatternExprDeclarationOf(n, name).map(t -> t));
    }

    private static Optional<Node> findLocalNameSource(Node current, String name) {
        ASTs.ReverseEvaluationOrder it = ASTs.reversePreOrderIterator(current);
        while (!(current instanceof TypeDeclaration) && it.hasNext()) {
            current = it.next();
            Optional<Node> maybeFound = NameResolver.isLocalNameSource(current, name);
            if (!maybeFound.isPresent()) continue;
            return maybeFound;
        }
        return Optional.empty();
    }

    private static Optional<Node> isFieldOfClass(ClassOrInterfaceDeclaration classDeclaration, String name) {
        return classDeclaration.getFields().stream().flatMap(field -> ASTs.isFieldDeclarationOf(field, name).stream()).findAny().map(Pair::getValue1);
    }

    private static Optional<Node> isNamedMemberOfClass(ClassOrInterfaceDeclaration classDeclaration, String name) {
        return classDeclaration.getMembers().stream().flatMap(bodyDecl -> ASTs.isNamedMemberOf(bodyDecl, name).stream()).findAny().map(n -> (Node)n);
    }

    private static Optional<Node> isNameOfClass(ClassOrInterfaceDeclaration classDeclaration, String name) {
        if (classDeclaration.getNameAsString().equals(name)) {
            return Optional.of(classDeclaration);
        }
        return Optional.empty();
    }

    private static Optional<Node> findClassLevelNameSource(ClassOrInterfaceDeclaration classDeclaration, String name) {
        return NameResolver.isFieldOfClass(classDeclaration, name).or(() -> NameResolver.isNamedMemberOfClass(classDeclaration, name)).or(() -> ASTs.isClassTypeParameterOf(classDeclaration, name).map(Pair::getValue1)).or(() -> NameResolver.isNameOfClass(classDeclaration, name));
    }

    static Optional<Node> resolveSimpleName(Node start, String name) {
        Node current = start;
        while (current.hasParentNode()) {
            ClassOrInterfaceDeclaration classDeclaration;
            Optional<Node> maybeClassMember;
            Optional<Node> maybeDeclaration = NameResolver.findLocalNameSource(current = (Node)current.getParentNode().get(), name);
            if (maybeDeclaration.isPresent()) {
                return maybeDeclaration;
            }
            if (!(current instanceof ClassOrInterfaceDeclaration) || !(maybeClassMember = NameResolver.findClassLevelNameSource(classDeclaration = (ClassOrInterfaceDeclaration)current, name)).isPresent()) continue;
            return maybeClassMember;
        }
        NodeList topLevelTypes = ((CompilationUnit)current.findCompilationUnit().get()).getTypes();
        Optional<TypeDeclaration> maybeDecl = topLevelTypes.stream().filter(t -> t.getNameAsString().equals(name)).findFirst();
        if (maybeDecl.isPresent()) {
            return maybeDecl.map(n -> n);
        }
        return Optional.empty();
    }

    static ClassOrInterfaceDeclaration findThisDeclaration(ThisExpr thisExpr) {
        ThisExpr current = thisExpr;
        while (current.hasParentNode() && !(current instanceof ClassOrInterfaceDeclaration)) {
            current = (Node)current.getParentNode().get();
        }
        return (ClassOrInterfaceDeclaration)current;
    }

    static Optional<LocalDeclaration> findLocalDeclarationOf(Node start, String name) {
        Optional<Node> maybeSource = NameResolver.resolveSimpleName(start, name);
        if (maybeSource.isPresent()) {
            Node source = maybeSource.get();
            if (source instanceof Parameter) {
                return Optional.of(new ParameterDeclaration((Parameter)source));
            }
            if (source instanceof VariableDeclarator) {
                VariableDeclarator vd = (VariableDeclarator)source;
                return ASTs.isVariableOfLocalDeclarationStmt(vd).map(t -> new ExpressionStmtVariableDeclaration((ExpressionStmt)t.getValue0(), (VariableDeclarationExpr)t.getValue1(), (VariableDeclarator)t.getValue2())).or(() -> ASTs.isResource(vd).map(p -> new TryResourceDeclaration((TryStmt)p.getValue0(), (VariableDeclarationExpr)p.getValue1(), vd))).or(() -> ASTs.isForInitVariable(vd).map(p -> new ForInitDeclaration((ForStmt)p.getValue0(), (VariableDeclarationExpr)p.getValue1(), vd))).or(() -> ASTs.isForEachVariable(vd).map(p -> new ForEachDeclaration((ForEachStmt)p.getValue0(), (VariableDeclarationExpr)p.getValue1(), vd)));
            }
        }
        return Optional.empty();
    }

    static Optional<LocalVariableDeclaration> findLocalVariableDeclarationOf(Node start, String name) {
        Optional<VariableDeclarator> maybeSource = NameResolver.resolveSimpleName(start, name).map(n -> n instanceof VariableDeclarator ? (VariableDeclarator)n : null);
        if (maybeSource.isPresent()) {
            VariableDeclarator vd = maybeSource.get();
            return ASTs.isVariableOfLocalDeclarationStmt(vd).map(t -> new ExpressionStmtVariableDeclaration((ExpressionStmt)t.getValue0(), (VariableDeclarationExpr)t.getValue1(), (VariableDeclarator)t.getValue2())).or(() -> ASTs.isResource(vd).map(p -> new TryResourceDeclaration((TryStmt)p.getValue0(), (VariableDeclarationExpr)p.getValue1(), vd))).or(() -> ASTs.isForInitVariable(vd).map(p -> new ForInitDeclaration((ForStmt)p.getValue0(), (VariableDeclarationExpr)p.getValue1(), vd))).or(() -> ASTs.isForEachVariable(vd).map(p -> new ForEachDeclaration((ForEachStmt)p.getValue0(), (VariableDeclarationExpr)p.getValue1(), vd)));
        }
        return Optional.empty();
    }
}

