/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public interface SourceDirectory
extends Comparable<SourceDirectory> {
    public Path path();

    public List<String> files();

    public static SourceDirectory createDefault(Path path, List<String> files) {
        return new DefaultSourceDirectory(path, files);
    }

    public static class DefaultSourceDirectory
    implements SourceDirectory {
        private final List<String> files;
        private final Path sourceDirectoryPath;

        DefaultSourceDirectory(Path sourceDirectoryPath, List<String> files) {
            this.sourceDirectoryPath = Objects.requireNonNull(sourceDirectoryPath);
            this.files = Objects.requireNonNull(files);
        }

        @Override
        public Path path() {
            return this.sourceDirectoryPath;
        }

        @Override
        public List<String> files() {
            return this.files;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultSourceDirectory that = (DefaultSourceDirectory)o;
            return this.files.equals(that.files) && this.sourceDirectoryPath.equals(that.sourceDirectoryPath);
        }

        public int hashCode() {
            return Objects.hash(this.files, this.sourceDirectoryPath);
        }

        public String toString() {
            return "DefaultSourceDirectory{files=" + this.files + ", sourceDirectoryPath='" + this.sourceDirectoryPath + "'}";
        }

        @Override
        public int compareTo(@NotNull SourceDirectory other) {
            return this.path().toString().compareTo(other.path().toString());
        }
    }
}

