/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import com.google.inject.AbstractModule;
import io.codemodder.Codemod;
import io.codemodder.CodemodParameter;
import io.codemodder.Parameter;
import io.codemodder.ParameterArgument;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

final class ParameterModule
extends AbstractModule {
    private final List<ParameterArgument> parameterArguments;
    private final List<java.lang.reflect.Parameter> injectableParameters;

    ParameterModule(List<ParameterArgument> codemodParameters, List<java.lang.reflect.Parameter> injectableParameters) {
        this.parameterArguments = Objects.requireNonNull(codemodParameters);
        this.injectableParameters = Objects.requireNonNull(injectableParameters);
    }

    protected void configure() {
        List codemodParameters = this.injectableParameters.stream().filter(param -> param.isAnnotationPresent(CodemodParameter.class)).filter(param -> param.getType().equals(Parameter.class)).collect(Collectors.toUnmodifiableList());
        for (java.lang.reflect.Parameter param2 : codemodParameters) {
            CodemodParameter codemodParameter = param2.getAnnotation(CodemodParameter.class);
            Codemod codemod = param2.getDeclaringExecutable().getDeclaringClass().getAnnotation(Codemod.class);
            ParameterArgument parameterArgument = this.parameterArguments.stream().filter(p -> p.codemodId().equals(codemod.id())).findFirst().orElse(null);
            Record parameter = parameterArgument != null ? new GivenParameter(codemodParameter, parameterArgument) : new NoValueProvidedParameter(codemodParameter);
            String defaultValue = parameter.getDefaultValue();
            Pattern p2 = Pattern.compile(codemodParameter.validationPattern());
            Matcher matcher = p2.matcher(defaultValue);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("invalid parameter default value: " + defaultValue + " for parameter: " + codemodParameter.name() + " in codemod: " + codemod.id() + " with validation pattern: " + codemodParameter.validationPattern());
            }
            this.bind(Parameter.class).annotatedWith((Annotation)codemodParameter).toInstance((Object)parameter);
        }
    }

    private record GivenParameter(CodemodParameter declaration, ParameterArgument parameterArgument) implements Parameter
    {
        private GivenParameter {
            Objects.requireNonNull(declaration);
            Objects.requireNonNull(parameterArgument);
        }

        @Override
        public String getQuestion() {
            return this.declaration.question();
        }

        @Override
        public String getType() {
            return this.declaration.type().name().toLowerCase();
        }

        @Override
        public String getName() {
            return this.declaration.name();
        }

        @Override
        public String getValue(Path path, int currentLine) {
            String file = this.parameterArgument.file();
            Integer line = this.parameterArgument.line();
            if (file == null && line == null) {
                return this.parameterArgument.value();
            }
            if (file == null || !file.equals(path.toString())) {
                return this.declaration.defaultValue();
            }
            if (line == null || line == currentLine) {
                return this.parameterArgument.value();
            }
            return this.declaration.defaultValue();
        }

        @Override
        public String getLabel() {
            return this.declaration.label();
        }

        @Override
        public String getDefaultValue() {
            if (this.parameterArgument.file() == null && this.parameterArgument.line() == null) {
                return this.parameterArgument.value();
            }
            return this.declaration.defaultValue();
        }
    }

    private record NoValueProvidedParameter(CodemodParameter declaration) implements Parameter
    {
        private NoValueProvidedParameter {
            Objects.requireNonNull(declaration);
        }

        @Override
        public String getQuestion() {
            return this.declaration.question();
        }

        @Override
        public String getType() {
            return this.declaration.type().name().toLowerCase();
        }

        @Override
        public String getName() {
            return this.declaration.name();
        }

        @Override
        public String getValue(Path path, int currentLine) {
            return this.declaration.defaultValue();
        }

        @Override
        public String getLabel() {
            return this.declaration.label();
        }

        @Override
        public String getDefaultValue() {
            return this.declaration.defaultValue();
        }
    }
}

