/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import io.codemodder.DependencyDescriptor;
import io.codemodder.DependencyGAV;
import io.codemodder.DependencyLicenses;
import java.util.Optional;

final class MarkdownDependencyDescriptor
implements DependencyDescriptor {
    MarkdownDependencyDescriptor() {
    }

    @Override
    public String create(DependencyGAV dependency) {
        Optional<Boolean> hasNoTransitiveDependencies;
        Optional<String> repositoryUrl;
        StringBuilder sb = new StringBuilder();
        Optional<String> justification = dependency.justification();
        if (justification.isPresent()) {
            sb.append(justification.get());
        } else {
            sb.append("This dependency change is required to use the new code.");
        }
        sb.append("\n\n");
        boolean hadPreviousFooterItem = false;
        Optional<String> license = dependency.license();
        if (license.isPresent()) {
            hadPreviousFooterItem = true;
            sb.append("License: ");
            sb.append(license.get());
            if (DependencyLicenses.isOpenSource(license.get())) {
                sb.append(" \u2705");
            } else {
                sb.append(" \u2753");
            }
        }
        if (hadPreviousFooterItem) {
            sb.append(" | ");
        }
        if ((repositoryUrl = dependency.repositoryUrl()).isPresent()) {
            hadPreviousFooterItem = true;
            sb.append("[Open source](");
            sb.append(repositoryUrl.get());
            sb.append(") \u2705");
        }
        if ((hasNoTransitiveDependencies = dependency.hasNoTransitiveDependencies()).isPresent() && hasNoTransitiveDependencies.get().booleanValue()) {
            if (hadPreviousFooterItem) {
                sb.append(" | ");
            } else {
                hadPreviousFooterItem = true;
            }
            sb.append("No transitive dependencies ");
            sb.append("\u2705");
        }
        if (hadPreviousFooterItem) {
            sb.append(" | ");
        }
        String moreFactsUrl = String.format("https://mvnrepository.com/artifact/%s/%s/%s", dependency.group(), dependency.artifact(), dependency.version());
        sb.append("[More facts](");
        sb.append(moreFactsUrl);
        sb.append(")\n");
        return sb.toString();
    }
}

