/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public interface LineIncludesExcludes {
    public boolean matches(int var1);

    public static LineIncludesExcludes fromIncludedLines(Set<Integer> allowedLines) {
        return new IncludeBasedLineIncludesExcludes(allowedLines);
    }

    public static LineIncludesExcludes fromExcludedLines(Set<Integer> allowedLines) {
        return new ExcludeBasedLineIncludesExcludes(allowedLines);
    }

    public static class IncludeBasedLineIncludesExcludes
    implements LineIncludesExcludes {
        private final Set<Integer> includedLines;

        private IncludeBasedLineIncludesExcludes(Set<Integer> includedLines) {
            this.includedLines = Collections.unmodifiableSet(Objects.requireNonNull(includedLines));
        }

        @Override
        public boolean matches(int line) {
            return this.includedLines.contains(line);
        }
    }

    public static class ExcludeBasedLineIncludesExcludes
    implements LineIncludesExcludes {
        private final Set<Integer> excludedLines;

        private ExcludeBasedLineIncludesExcludes(Set<Integer> excludedLines) {
            this.excludedLines = Collections.unmodifiableSet(Objects.requireNonNull(excludedLines));
        }

        @Override
        public boolean matches(int line) {
            return !this.excludedLines.contains(line);
        }
    }

    public static class MatchesEverything
    implements LineIncludesExcludes {
        @Override
        public boolean matches(int line) {
            return true;
        }
    }
}

