/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import io.codemodder.Position;
import io.codemodder.XPathStreamEventHandler;
import io.codemodder.XPathStreamProcessChange;
import io.codemodder.XPathStreamProcessor;
import io.github.pixee.security.XMLInputFactorySecurity;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.io.SAXContentHandler;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.DefaultElement;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

final class DefaultXPathStreamProcessor
implements XPathStreamProcessor {
    DefaultXPathStreamProcessor() {
    }

    @Override
    public Optional<XPathStreamProcessChange> process(Path path, String xpathExpression, XPathStreamEventHandler handler) throws SAXException, IOException, XMLStreamException {
        Document doc;
        PositionCapturingReader reader = new PositionCapturingReader();
        reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
        reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        reader.setDocumentFactory(new LocatorAwareDocumentFactory());
        String xml = Files.readString(path);
        try {
            doc = reader.read(new StringReader(xml));
        }
        catch (DocumentException e) {
            throw new IOException("Problem reading document", e);
        }
        List<Position> httpMethodPositions = DocumentHelper.selectNodes((String)xpathExpression, (Node)doc).stream().map(node -> (LocationAwareElement)((Object)node)).map(element -> new Position(element.getLine(), element.getColumn())).collect(Collectors.toUnmodifiableList());
        if (httpMethodPositions.isEmpty()) {
            return Optional.empty();
        }
        XMLInputFactory inputFactory = XMLInputFactorySecurity.hardenFactory((XMLInputFactory)XMLInputFactory.newFactory());
        XMLEventReader xmlReader = inputFactory.createXMLEventReader(Files.newInputStream(path, new OpenOption[0]));
        XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
        StringWriter sw = new StringWriter();
        XMLEventWriter xmlWriter = outputFactory.createXMLEventWriter(sw);
        while (xmlReader.hasNext()) {
            XMLEvent currentEvent = xmlReader.nextEvent();
            Location location = currentEvent.getLocation();
            if (this.doesPositionMatch(httpMethodPositions, location)) {
                handler.handle(xmlReader, xmlWriter, currentEvent);
                continue;
            }
            xmlWriter.add(currentEvent);
        }
        Object transformedXml = sw.toString();
        if (((String)transformedXml).startsWith("<?xml") && !xml.startsWith("<?xml")) {
            transformedXml = ((String)transformedXml).substring(((String)transformedXml).indexOf(62) + 1);
        }
        if (xml.stripLeading().startsWith("<?xml")) {
            String xmlHead = xml.substring(0, xml.indexOf(60, xml.indexOf(60) + 1));
            String transformedXmlTail = ((String)transformedXml).substring(((String)transformedXml).indexOf(60, ((String)transformedXml).indexOf(60) + 1));
            transformedXml = xmlHead + transformedXmlTail;
        }
        Set<Integer> linesAffected = httpMethodPositions.stream().map(pos -> pos.line()).collect(Collectors.toUnmodifiableSet());
        List lines = ((String)transformedXml).lines().collect(Collectors.toUnmodifiableList());
        ArrayList<String> updatedLines = new ArrayList<String>(lines.size() - linesAffected.size());
        for (int i = 1; i <= lines.size(); ++i) {
            String actualLine = (String)lines.get(i - 1);
            if (linesAffected.contains(i) && actualLine.isBlank()) continue;
            updatedLines.add(actualLine);
        }
        transformedXml = String.join((CharSequence)"\n", updatedLines);
        if (xml.endsWith("\n") && !((String)transformedXml).endsWith("\n")) {
            transformedXml = (String)transformedXml + "\n";
        }
        Path tmpFile = Files.createTempFile("codemodder", ".xml", new FileAttribute[0]);
        Files.writeString(tmpFile, (CharSequence)transformedXml, new OpenOption[0]);
        XPathStreamProcessChange.Default change = new XPathStreamProcessChange.Default(linesAffected, tmpFile);
        return Optional.of(change);
    }

    private boolean doesPositionMatch(List<Position> positions, Location location) {
        return positions.stream().anyMatch(position -> position.column().intValue() == location.getColumnNumber() && position.line().intValue() == location.getLineNumber());
    }

    private static class PositionCapturingReader
    extends SAXReader {
        private PositionCapturingReader() {
        }

        protected SAXContentHandler createContentHandler(XMLReader reader) {
            return new PositionCapturingContentHandler(this.getDocumentFactory(), (ElementHandler)this.getDispatchHandler());
        }

        public void setDocumentFactory(DocumentFactory documentFactory) {
            super.setDocumentFactory(documentFactory);
        }
    }

    private static class LocatorAwareDocumentFactory
    extends DocumentFactory {
        private Locator locator;

        public void setLocator(Locator locator) {
            this.locator = locator;
        }

        public Element createElement(QName qname) {
            LocationAwareElement element = new LocationAwareElement(qname);
            if (this.locator != null) {
                element.setLine(this.locator.getLineNumber());
                element.setColumn(this.locator.getColumnNumber());
            }
            return element;
        }
    }

    private static class LocationAwareElement
    extends DefaultElement {
        private int lineNumber = -1;
        private int column = -1;

        public LocationAwareElement(QName qname) {
            super(qname);
        }

        public int getLine() {
            return this.lineNumber;
        }

        int getColumn() {
            return this.column;
        }

        public void setLine(int lineNumber) {
            this.lineNumber = lineNumber;
        }

        public void setColumn(int column) {
            this.column = column;
        }
    }

    private static class PositionCapturingContentHandler
    extends SAXContentHandler {
        private Locator locator;
        private final DocumentFactory documentFactory;

        public PositionCapturingContentHandler(DocumentFactory documentFactory, ElementHandler elementHandler) {
            super(documentFactory, elementHandler);
            this.documentFactory = documentFactory;
        }

        public void setDocumentLocator(Locator documentLocator) {
            super.setDocumentLocator(documentLocator);
            this.locator = documentLocator;
            if (this.documentFactory instanceof LocatorAwareDocumentFactory) {
                ((LocatorAwareDocumentFactory)this.documentFactory).setLocator(documentLocator);
            }
        }

        public Locator getLocator() {
            return this.locator;
        }
    }
}

