/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.javaparser;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.printer.lexicalpreservation.LexicalPreservingPrinter;
import io.codemodder.CodemodChange;
import io.codemodder.CodemodInvocationContext;
import io.codemodder.CodemodRunner;
import io.codemodder.EncodingDetector;
import io.codemodder.javaparser.CachingJavaParser;
import io.codemodder.javaparser.JavaParserChanger;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Objects;

public final class JavaParserCodemodRunner
implements CodemodRunner {
    private final JavaParserChanger javaParserChanger;
    private final CachingJavaParser parser;
    private final EncodingDetector encodingDetector;

    public JavaParserCodemodRunner(CachingJavaParser parser, JavaParserChanger javaParserChanger, EncodingDetector encodingDetector) {
        this.parser = Objects.requireNonNull(parser);
        this.javaParserChanger = Objects.requireNonNull(javaParserChanger);
        this.encodingDetector = Objects.requireNonNull(encodingDetector);
    }

    @Override
    public boolean supports(Path path) {
        return path.getFileName().toString().toLowerCase().endsWith(".java");
    }

    @Override
    public List<CodemodChange> run(CodemodInvocationContext context) throws IOException {
        Path file = context.path();
        CompilationUnit cu = this.parser.parseJavaFile(file);
        List<CodemodChange> changes = this.javaParserChanger.visit(context, cu);
        if (!changes.isEmpty()) {
            String encodingName = this.encodingDetector.detect(file).orElse("UTF-8");
            Charset encoding = Charset.forName(encodingName);
            String modified = LexicalPreservingPrinter.print((Node)cu);
            Files.writeString(file, (CharSequence)modified, encoding, StandardOpenOption.TRUNCATE_EXISTING);
        }
        return changes;
    }
}

