/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.javaparser;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.printer.lexicalpreservation.LexicalPreservingPrinter;
import io.codemodder.javaparser.CachingJavaParser;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

final class DefaultCachingJavaParser
implements CachingJavaParser {
    private final JavaParser parser;
    private final Map<Path, CompilationUnit> cache;

    DefaultCachingJavaParser(JavaParser parser) {
        this.parser = Objects.requireNonNull(parser);
        this.cache = new HashMap<Path, CompilationUnit>();
    }

    @Override
    public CompilationUnit parseJavaFile(Path file) throws IOException {
        if (this.cache.containsKey(file)) {
            return this.cache.get(file);
        }
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            ParseResult result = this.parser.parse(in);
            if (!result.isSuccessful()) {
                throw new RuntimeException("can't parse file");
            }
            CompilationUnit cu = (CompilationUnit)result.getResult().orElseThrow();
            LexicalPreservingPrinter.setup((Node)cu);
            this.cache.put(file, cu);
            CompilationUnit compilationUnit = cu;
            return compilationUnit;
        }
    }
}

