/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.ast;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithBody;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.LabeledStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.stmt.TryStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import io.codemodder.ast.LocalScope;
import java.util.Optional;

public final class ASTTransforms {
    public static void addImportIfMissing(CompilationUnit cu, String className) {
        ImportDeclaration newImport;
        NodeList imports = cu.getImports();
        if (ASTTransforms.addInOrdrerIfNeeded(className, (NodeList<ImportDeclaration>)imports, newImport = new ImportDeclaration(className, false, false))) {
            return;
        }
        cu.addImport(className);
    }

    private static boolean addInOrdrerIfNeeded(String className, NodeList<ImportDeclaration> imports, ImportDeclaration newImport) {
        if (imports.contains((Node)newImport)) {
            return true;
        }
        for (int i = 0; i < imports.size(); ++i) {
            ImportDeclaration existingImport = (ImportDeclaration)imports.get(i);
            if (existingImport.getNameAsString().compareTo(className) <= 0) continue;
            if (i == 0) {
                existingImport.replace((Node)newImport);
                imports.addAfter((Node)existingImport, (Node)newImport);
                return true;
            }
            imports.addBefore((Node)newImport, (Node)existingImport);
            return true;
        }
        return false;
    }

    public static void addImportIfMissing(CompilationUnit cu, Class<?> clazz) {
        ASTTransforms.addImportIfMissing(cu, clazz.getName());
    }

    public static void addStaticImportIfMissing(CompilationUnit cu, String method) {
        ImportDeclaration newMethodImport;
        NodeList imports = cu.getImports();
        if (ASTTransforms.addInOrdrerIfNeeded(method, (NodeList<ImportDeclaration>)imports, newMethodImport = new ImportDeclaration(method, true, false))) {
            return;
        }
        cu.addImport(method, true, false);
    }

    public static void addStatementBeforeStatement(Statement existingStatement, Statement newStatement) {
        Node parent = (Node)existingStatement.getParentNode().get();
        if (parent instanceof NodeWithBody || parent instanceof IfStmt || parent instanceof LabeledStmt || parent instanceof LambdaExpr) {
            BlockStmt newBody = new BlockStmt();
            existingStatement.replace((Node)newBody);
            newBody.addStatement(newStatement);
            newBody.addStatement(existingStatement);
        } else {
            BlockStmt block = (BlockStmt)parent;
            if (existingStatement.equals((Object)block.getStatement(0))) {
                existingStatement.replace((Node)newStatement);
                block.addStatement(1, existingStatement);
            } else {
                block.getStatements().addBefore((Node)newStatement, (Node)existingStatement);
            }
        }
    }

    public static void addStatementAfterStatement(Statement existingStatement, Statement newStatement) {
        Node parent = (Node)existingStatement.getParentNode().get();
        if (parent instanceof NodeWithBody || parent instanceof IfStmt || parent instanceof LabeledStmt || parent instanceof LambdaExpr) {
            BlockStmt newBody = new BlockStmt();
            existingStatement.replace((Node)newBody);
            newBody.addStatement(existingStatement);
            newBody.addStatement(newStatement);
        } else {
            BlockStmt block = (BlockStmt)parent;
            block.getStatements().addAfter((Node)newStatement, (Node)existingStatement);
        }
    }

    public static TryStmt wrapIntoResource(ExpressionStmt stmt, VariableDeclarationExpr vdecl, LocalScope scope) {
        TryStmt wrapper = new TryStmt();
        wrapper.getResources().add((Node)vdecl);
        BlockStmt block = new BlockStmt();
        scope.getStatements().forEach(s -> {
            s.remove();
            block.addStatement(s);
        });
        wrapper.setTryBlock(block);
        stmt.replace((Node)wrapper);
        return wrapper;
    }

    public static TryStmt splitResources(TryStmt stmt, int index) {
        int i;
        NodeList resources = stmt.getResources();
        NodeList head = new NodeList();
        NodeList tail = new NodeList();
        for (i = 0; i <= index; ++i) {
            head.add((Node)((Expression)resources.get(i)));
        }
        for (i = index + 1; i < resources.size(); ++i) {
            tail.add((Node)((Expression)resources.get(i)));
        }
        stmt.setResources(head);
        TryStmt innerTry = new TryStmt();
        innerTry.setResources(tail);
        innerTry.setTryBlock(stmt.getTryBlock());
        stmt.setTryBlock(new BlockStmt(new NodeList((Node[])new Statement[]{innerTry})));
        return stmt;
    }

    public static TryStmt combineResources(TryStmt innerTry) {
        TryStmt outerTry = (TryStmt)innerTry.getParentNode().flatMap(Node::getParentNode).get();
        innerTry.getResources().forEach(arg_0 -> ((NodeList)outerTry.getResources()).add(arg_0));
        outerTry.getTryBlock().getStatements().stream().skip(1L).forEach(arg_0 -> ((BlockStmt)innerTry.getTryBlock()).addStatement(arg_0));
        outerTry.setTryBlock(innerTry.getTryBlock());
        return outerTry;
    }

    public static void removeImportIfUnused(CompilationUnit cu, String className) {
        NodeList imports = cu.getImports();
        Optional<ImportDeclaration> importToRemove = imports.stream().filter(i -> i.getNameAsString().equals(className)).findFirst();
        if (importToRemove.isEmpty()) {
            return;
        }
        String simpleName = className.substring(className.lastIndexOf(46) + 1);
        if (cu.findAll(Node.class).stream().filter(n -> n instanceof NodeWithSimpleName).map(n -> (NodeWithSimpleName)n).anyMatch(n -> n.getNameAsString().equals(simpleName))) {
            return;
        }
        if (cu.findAll(ClassOrInterfaceType.class).stream().anyMatch(n -> n.getNameAsString().equals(simpleName))) {
            return;
        }
        cu.remove((Node)importToRemove.get());
    }
}

