/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import com.contrastsecurity.sarif.Region;
import com.contrastsecurity.sarif.Result;
import com.github.javaparser.Range;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.google.common.annotations.VisibleForTesting;
import io.codemodder.CodemodChange;
import io.codemodder.CodemodInvocationContext;
import io.codemodder.CodemodReporterStrategy;
import io.codemodder.RegionExtractor;
import io.codemodder.RegionNodeMatcher;
import io.codemodder.RuleSarif;
import io.codemodder.javaparser.JavaParserChanger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class SarifPluginJavaParserChanger<T extends Node>
extends JavaParserChanger {
    @VisibleForTesting
    public final RuleSarif sarif;
    private final Class<? extends Node> nodeType;
    private final RegionExtractor regionExtractor;
    private final RegionNodeMatcher regionNodeMatcher;

    protected SarifPluginJavaParserChanger(RuleSarif sarif, Class<? extends Node> nodeType) {
        this(sarif, nodeType, RegionExtractor.FROM_FIRST_LOCATION, RegionNodeMatcher.EXACT_MATCH);
    }

    protected SarifPluginJavaParserChanger(RuleSarif sarif, Class<? extends Node> nodeType, RegionExtractor regionExtractor) {
        this(sarif, nodeType, regionExtractor, RegionNodeMatcher.EXACT_MATCH);
    }

    protected SarifPluginJavaParserChanger(RuleSarif sarif, Class<? extends Node> nodeType, CodemodReporterStrategy codemodReporterStrategy) {
        this(sarif, nodeType, RegionNodeMatcher.EXACT_MATCH, codemodReporterStrategy);
    }

    protected SarifPluginJavaParserChanger(RuleSarif sarif, Class<? extends Node> nodeType, RegionNodeMatcher regionNodeMatcher) {
        this(sarif, nodeType, RegionExtractor.FROM_FIRST_LOCATION, regionNodeMatcher);
    }

    protected SarifPluginJavaParserChanger(RuleSarif sarif, Class<? extends Node> nodeType, RegionNodeMatcher regionNodeMatcher, CodemodReporterStrategy reporterStrategy) {
        this(sarif, nodeType, RegionExtractor.FROM_FIRST_LOCATION, regionNodeMatcher, reporterStrategy);
    }

    protected SarifPluginJavaParserChanger(RuleSarif sarif, Class<? extends Node> nodeType, RegionExtractor regionExtractor, RegionNodeMatcher regionNodeMatcher) {
        this.sarif = Objects.requireNonNull(sarif);
        this.nodeType = Objects.requireNonNull(nodeType);
        this.regionExtractor = Objects.requireNonNull(regionExtractor);
        this.regionNodeMatcher = Objects.requireNonNull(regionNodeMatcher);
    }

    protected SarifPluginJavaParserChanger(RuleSarif sarif, Class<? extends Node> nodeType, RegionExtractor regionExtractor, RegionNodeMatcher regionNodeMatcher, CodemodReporterStrategy reporter) {
        super(reporter);
        this.sarif = Objects.requireNonNull(sarif);
        this.nodeType = Objects.requireNonNull(nodeType);
        this.regionExtractor = Objects.requireNonNull(regionExtractor);
        this.regionNodeMatcher = Objects.requireNonNull(regionNodeMatcher);
    }

    @Override
    public List<CodemodChange> visit(CodemodInvocationContext context, CompilationUnit cu) {
        List<Result> results = this.sarif.getResultsByPath(context.path());
        if (results.isEmpty()) {
            return List.of();
        }
        List allNodes = cu.findAll(this.nodeType);
        ArrayList<CodemodChange> codemodChanges = new ArrayList<CodemodChange>();
        for (Result result : results) {
            for (Node node : allNodes) {
                boolean changeSuccessful;
                Range range;
                Region region = this.regionExtractor.from(result);
                if (!this.nodeType.isAssignableFrom(node.getClass()) || !context.lineIncludesExcludes().matches(region.getStartLine()) || !node.getRange().isPresent() || !this.regionNodeMatcher.matches(region, range = (Range)node.getRange().get()) || !(changeSuccessful = this.onResultFound(context, cu, node, result))) continue;
                codemodChanges.add(CodemodChange.from((int)region.getStartLine(), this.dependenciesRequired()));
            }
        }
        return codemodChanges;
    }

    public abstract boolean onResultFound(CodemodInvocationContext var1, CompilationUnit var2, T var3, Result var4);
}

