/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import com.github.difflib.DiffUtils;
import com.github.difflib.UnifiedDiffUtils;
import com.github.difflib.patch.Patch;
import io.codemodder.CodeChanger;
import io.codemodder.CodeTFProvider;
import io.codemodder.CodemodChange;
import io.codemodder.CodemodExecutor;
import io.codemodder.CodemodIdPair;
import io.codemodder.CodemodPackageUpdateResult;
import io.codemodder.CodemodRunner;
import io.codemodder.DefaultCodeDirectory;
import io.codemodder.DefaultCodemodInvocationContext;
import io.codemodder.DependencyGAV;
import io.codemodder.DependencyUpdateResult;
import io.codemodder.EncodingDetector;
import io.codemodder.IncludesExcludes;
import io.codemodder.LineIncludesExcludes;
import io.codemodder.ProjectProvider;
import io.codemodder.RawFileChanger;
import io.codemodder.RawFileCodemodRunner;
import io.codemodder.codetf.CodeTFChange;
import io.codemodder.codetf.CodeTFChangesetEntry;
import io.codemodder.codetf.CodeTFPackageAction;
import io.codemodder.codetf.CodeTFResult;
import io.codemodder.javaparser.CachingJavaParser;
import io.codemodder.javaparser.JavaParserChanger;
import io.codemodder.javaparser.JavaParserCodemodRunner;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

final class DefaultCodemodExecutor
implements CodemodExecutor {
    private final CodemodIdPair codemod;
    private final List<ProjectProvider> projectProviders;
    private final List<CodeTFProvider> codetfProviders;
    private final CachingJavaParser cachingJavaParser;
    private final Path projectDir;
    private final IncludesExcludes includesExcludes;
    private final EncodingDetector encodingDetector;

    DefaultCodemodExecutor(Path projectDir, IncludesExcludes includesExcludes, CodemodIdPair codemod, List<ProjectProvider> projectProviders, List<CodeTFProvider> codetfProviders, CachingJavaParser cachingJavaParser, EncodingDetector encodingDetector) {
        this.projectDir = Objects.requireNonNull(projectDir);
        this.includesExcludes = Objects.requireNonNull(includesExcludes);
        this.codemod = Objects.requireNonNull(codemod);
        this.codetfProviders = Objects.requireNonNull(codetfProviders);
        this.projectProviders = Objects.requireNonNull(projectProviders);
        this.cachingJavaParser = Objects.requireNonNull(cachingJavaParser);
        this.encodingDetector = Objects.requireNonNull(encodingDetector);
    }

    @Override
    public CodeTFResult execute(List<Path> filePaths) {
        CodemodRunner codemodRunner;
        ArrayList<Object> changeset = new ArrayList<Object>();
        HashSet<Path> unscannableFiles = new HashSet<Path>();
        DefaultCodeDirectory codeDirectory = new DefaultCodeDirectory(this.projectDir);
        CodeChanger codeChanger = this.codemod.getChanger();
        if (codeChanger instanceof JavaParserChanger) {
            codemodRunner = new JavaParserCodemodRunner(this.cachingJavaParser, (JavaParserChanger)codeChanger, this.encodingDetector);
        } else if (codeChanger instanceof RawFileChanger) {
            codemodRunner = new RawFileCodemodRunner((RawFileChanger)codeChanger);
        } else {
            throw new UnsupportedOperationException("unsupported codeChanger type: " + codeChanger.getClass().getName());
        }
        List<Path> codemodTargetFiles = filePaths.stream().filter(codemodRunner::supports).sorted().toList();
        for (Path filePath : codemodTargetFiles) {
            LineIncludesExcludes lineIncludesExcludes = this.includesExcludes.getIncludesExcludesForFile(filePath.toFile());
            DefaultCodemodInvocationContext context = new DefaultCodemodInvocationContext(codeDirectory, filePath, this.codemod.getId(), lineIncludesExcludes);
            try {
                List<Object> pkgActions;
                List<String> beforeFile = Files.readAllLines(filePath);
                List<CodemodChange> codemodChanges = codemodRunner.run(context);
                if (codemodChanges.isEmpty()) continue;
                List<DependencyGAV> dependencies = codemodChanges.stream().map(CodemodChange::getDependenciesNeeded).flatMap(Collection::stream).distinct().collect(Collectors.toList());
                List<Object> dependencyChangesetEntries = Collections.emptyList();
                if (!dependencies.isEmpty()) {
                    CodemodPackageUpdateResult packageAddResult = this.addPackages(filePath, dependencies);
                    unscannableFiles.addAll(packageAddResult.filesFailedToChange());
                    pkgActions = packageAddResult.packageActions();
                    dependencyChangesetEntries = packageAddResult.manifestChanges();
                } else {
                    pkgActions = Collections.emptyList();
                }
                List changes = codemodChanges.stream().map(change -> this.translateCodemodChangetoCodeTFChange(codeChanger, filePath, (CodemodChange)change, (List<CodeTFPackageAction>)pkgActions)).collect(Collectors.toList());
                List<String> afterFile = Files.readAllLines(filePath);
                List patchDiff = UnifiedDiffUtils.generateUnifiedDiff((String)filePath.getFileName().toString(), (String)filePath.getFileName().toString(), beforeFile, (Patch)DiffUtils.diff(beforeFile, afterFile), (int)3);
                String diff = String.join((CharSequence)"\n", patchDiff);
                changeset.add(new CodeTFChangesetEntry(this.getRelativePath(this.projectDir, filePath), diff, changes));
                changeset.addAll(dependencyChangesetEntries);
            }
            catch (Exception e) {
                unscannableFiles.add(filePath);
                e.printStackTrace();
            }
        }
        CodeTFResult result = new CodeTFResult(this.codemod.getId(), codeChanger.getSummary(), codeChanger.getDescription(), unscannableFiles.stream().map(file -> this.getRelativePath(this.projectDir, (Path)file)).collect(Collectors.toSet()), codeChanger.getReferences(), Collections.emptyMap(), changeset);
        for (CodeTFProvider provider : this.codetfProviders) {
            result = provider.onResultCreated(result);
        }
        return result;
    }

    @NotNull
    private CodeTFChange translateCodemodChangetoCodeTFChange(CodeChanger codeChanger, Path filePath, CodemodChange codemodChange, List<CodeTFPackageAction> pkgActions) {
        Optional<String> customizedChangeDescription = codemodChange.getDescription();
        String changeDescription = customizedChangeDescription.orElse(codeChanger.getIndividualChangeDescription(filePath, codemodChange));
        CodeTFChange change = new CodeTFChange(codemodChange.lineNumber(), Collections.emptyMap(), changeDescription, pkgActions, codemodChange.getParameters());
        for (CodeTFProvider provider : this.codetfProviders) {
            change = provider.onChangeCreated(filePath, this.codemod.getId(), change);
        }
        return change;
    }

    private CodemodPackageUpdateResult addPackages(Path file, List<DependencyGAV> dependencies) throws IOException {
        ArrayList<CodeTFPackageAction> pkgActions = new ArrayList<CodeTFPackageAction>();
        HashSet<Path> unscannableFiles = new HashSet<Path>();
        ArrayList<DependencyGAV> skippedDependencies = new ArrayList<DependencyGAV>();
        ArrayList<CodeTFChangesetEntry> pkgChanges = new ArrayList<CodeTFChangesetEntry>();
        for (ProjectProvider projectProvider : this.projectProviders) {
            String packageUrl;
            DependencyUpdateResult result = projectProvider.updateDependencies(this.projectDir, file, dependencies);
            unscannableFiles.addAll(result.erroredFiles().stream().map(Path::toAbsolutePath).toList());
            pkgChanges.addAll(result.packageChanges());
            for (DependencyGAV dependency : result.injectedPackages()) {
                packageUrl = DefaultCodemodExecutor.toPackageUrl(dependency);
                pkgActions.add(new CodeTFPackageAction(CodeTFPackageAction.CodeTFPackageActionType.ADD, CodeTFPackageAction.CodeTFPackageActionResult.COMPLETED, packageUrl));
            }
            for (DependencyGAV dependency : result.skippedPackages()) {
                packageUrl = DefaultCodemodExecutor.toPackageUrl(dependency);
                skippedDependencies.add(dependency);
                pkgActions.add(new CodeTFPackageAction(CodeTFPackageAction.CodeTFPackageActionType.ADD, CodeTFPackageAction.CodeTFPackageActionResult.SKIPPED, packageUrl));
            }
            dependencies.removeAll(new HashSet<DependencyGAV>(result.injectedPackages()));
        }
        dependencies.stream().filter(d -> !skippedDependencies.contains(d)).forEach(dep -> pkgActions.add(new CodeTFPackageAction(CodeTFPackageAction.CodeTFPackageActionType.ADD, CodeTFPackageAction.CodeTFPackageActionResult.FAILED, DefaultCodemodExecutor.toPackageUrl(dep))));
        return CodemodPackageUpdateResult.from(pkgActions, pkgChanges, unscannableFiles);
    }

    @VisibleForTesting
    static String toPackageUrl(DependencyGAV dependency) {
        return "pkg:maven/" + dependency.group() + "/" + dependency.artifact() + "@" + dependency.version();
    }

    private String getRelativePath(Path projectDir, Path filePath) {
        String path = projectDir.relativize(filePath).toString();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }
}

