/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.javaparser;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import io.codemodder.ast.ASTs;
import io.codemodder.ast.LocalVariableDeclaration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ASTExpectations {
    private ASTExpectations() {
    }

    public static NodeExpectation expect(Node node) {
        return new NodeExpectation(node);
    }

    public static class NodeExpectation
    implements ASTExpectationProducer<Node> {
        private Optional<Node> nodeRef;

        public NodeExpectation(Node node) {
            this.nodeRef = Optional.of(node);
        }

        public NodeExpectation withBlockParent() {
            if (this.nodeRef.isEmpty()) {
                return this;
            }
            this.nodeRef = this.nodeRef.filter(n -> n.getParentNode().filter(parent -> parent instanceof BlockStmt).isPresent());
            return this;
        }

        public VariableDeclarationExprExpectation toBeVariableDeclarationStatement() {
            Optional<VariableDeclarationExpr> vde = this.nodeRef.map(n -> n instanceof ExpressionStmt ? (ExpressionStmt)n : null).map(ExpressionStmt::getExpression).map(expr -> expr.isVariableDeclarationExpr() ? expr.asVariableDeclarationExpr() : null);
            return new VariableDeclarationExprExpectation(vde);
        }

        @Override
        public Optional<Node> result() {
            return this.nodeRef;
        }
    }

    public static class MethodCallExpectation
    implements ASTExpectationProducer<MethodCallExpr> {
        private final Optional<MethodCallExpr> methodCallExpr;

        public MethodCallExpectation(Optional<MethodCallExpr> methodCallExpr) {
            this.methodCallExpr = Objects.requireNonNull(methodCallExpr);
        }

        @Override
        public Optional<MethodCallExpr> result() {
            return this.methodCallExpr;
        }
    }

    public static class LocalVariableDeclaratorExpectation
    implements ASTExpectationProducer<VariableDeclarator> {
        private Optional<VariableDeclarator> varRef;

        public LocalVariableDeclaratorExpectation(Optional<VariableDeclarator> variableDeclarator) {
            this.varRef = Objects.requireNonNull(variableDeclarator);
        }

        public LocalVariableDeclaratorExpectation withDirectReferenceCount(int count) {
            if (this.varRef.isEmpty()) {
                return this;
            }
            Optional<LocalVariableDeclaration> localVariableDeclaration = LocalVariableDeclaration.fromVariableDeclarator(this.varRef.get());
            if (localVariableDeclaration.isEmpty()) {
                this.varRef = Optional.empty();
                return this;
            }
            List<NameExpr> allReferences = ASTs.findAllReferences(localVariableDeclaration.get());
            if (allReferences.size() != count) {
                this.varRef = Optional.empty();
            }
            return this;
        }

        public MethodCallExpectation toBeInitializedByMethodCall() {
            if (this.varRef.isEmpty()) {
                return new MethodCallExpectation(Optional.empty());
            }
            Optional<MethodCallExpr> mc = this.varRef.flatMap(VariableDeclarator::getInitializer).filter(MethodCallExpr.class::isInstance).map(MethodCallExpr.class::cast);
            if (mc.isEmpty()) {
                this.varRef = Optional.empty();
            }
            return new MethodCallExpectation(mc);
        }

        @Override
        public Optional<VariableDeclarator> result() {
            return this.varRef;
        }
    }

    public static class VariableDeclarationExprExpectation
    implements ASTExpectationProducer<VariableDeclarationExpr> {
        private Optional<VariableDeclarationExpr> varDefExprRef;

        public VariableDeclarationExprExpectation(Optional<VariableDeclarationExpr> expr) {
            this.varDefExprRef = expr;
        }

        public LocalVariableDeclaratorExpectation toBeSingleLocalVariableDefinition() {
            if (this.varDefExprRef.isEmpty()) {
                return new LocalVariableDeclaratorExpectation(Optional.empty());
            }
            VariableDeclarationExpr variableDeclarationExpr = this.varDefExprRef.get();
            if (variableDeclarationExpr.getVariables().size() != 1) {
                this.varDefExprRef = Optional.empty();
                return new LocalVariableDeclaratorExpectation(Optional.empty());
            }
            Optional<LocalVariableDeclaration> localVariableDeclaration = LocalVariableDeclaration.fromVariableDeclarator(variableDeclarationExpr.getVariable(0));
            if (localVariableDeclaration.isPresent()) {
                return new LocalVariableDeclaratorExpectation(Optional.of((VariableDeclarator)variableDeclarationExpr.getVariables().get(0)));
            }
            return new LocalVariableDeclaratorExpectation(Optional.empty());
        }

        @Override
        public Optional<VariableDeclarationExpr> result() {
            return this.varDefExprRef;
        }
    }

    static interface ASTExpectationProducer<T extends Node> {
        public Optional<T> result();
    }
}

