/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.javaparser.JavaParser;
import com.google.common.base.Stopwatch;
import io.codemodder.CodeChanger;
import io.codemodder.CodeTFProvider;
import io.codemodder.Codemod;
import io.codemodder.CodemodIdPair;
import io.codemodder.CodemodLoader;
import io.codemodder.CodemodRegulator;
import io.codemodder.DefaultCodemodExecutor;
import io.codemodder.DefaultEncodingDetector;
import io.codemodder.DefaultRuleSetting;
import io.codemodder.EncodingDetector;
import io.codemodder.FileFinder;
import io.codemodder.IncludesExcludes;
import io.codemodder.LoggingConfigurator;
import io.codemodder.ParameterArgument;
import io.codemodder.ProjectProvider;
import io.codemodder.RuleSarif;
import io.codemodder.SarifParser;
import io.codemodder.SourceDirectory;
import io.codemodder.SourceDirectoryLister;
import io.codemodder.codetf.CodeTFReport;
import io.codemodder.codetf.CodeTFReportGenerator;
import io.codemodder.codetf.CodeTFResult;
import io.codemodder.javaparser.CachingJavaParser;
import io.codemodder.javaparser.JavaParserFactory;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="codemodder", mixinStandardHelpOptions=true, description={"Run a codemodder codemod"})
final class CLI
implements Callable<Integer> {
    private final List<Class<? extends CodeChanger>> codemodTypes;
    private final Clock clock;
    private final FileFinder fileFinder;
    private final EncodingDetector encodingDetector;
    private final JavaParserFactory javaParserFactory;
    private final SourceDirectoryLister sourceDirectoryLister;
    private final CodeTFReportGenerator reportGenerator;
    private final String[] args;
    @CommandLine.Option(names={"--output"}, description={"the output file to produce"})
    private File output;
    @CommandLine.Option(names={"--dry-run"}, description={"do everything except make changes to files"}, defaultValue="false")
    private boolean dryRun;
    @CommandLine.Option(names={"--dont-exit"}, description={"dont exit the process after running the codemods"}, hidden=true, defaultValue="false")
    private boolean dontExit;
    @CommandLine.Option(names={"--verbose"}, description={"print more to stdout"}, defaultValue="false")
    private boolean verbose;
    @CommandLine.Option(names={"--output-format"}, description={"the format for the data output file (\"codetf\" or \"diff\")"}, defaultValue="codetf")
    private OutputFormat outputFormat;
    @CommandLine.Option(names={"--list"}, description={"print codemod(s) metadata, then exit"}, defaultValue="false")
    private boolean listCodemods;
    @CommandLine.Option(names={"--path-include"}, description={"comma-separated set of UNIX glob patterns to include"}, split=",")
    private List<String> pathIncludes;
    @CommandLine.Option(names={"--path-exclude"}, description={"comma-separated set of UNIX glob patterns to exclude"}, split=",")
    private List<String> pathExcludes;
    @CommandLine.Option(names={"--codemod-include"}, description={"comma-separated set of codemod IDs to include"}, split=",")
    private List<String> codemodIncludes;
    @CommandLine.Option(names={"--parameter"}, description={"a codemod parameter"})
    private List<String> codemodParameters;
    @CommandLine.Option(names={"--codemod-exclude"}, description={"comma-separated set of codemod IDs to exclude"}, split=",")
    private List<String> codemodExcludes;
    @CommandLine.Parameters(arity="0..1", paramLabel="DIRECTORY", description={"the directory to run the codemod on"})
    private File projectDirectory;
    @CommandLine.Option(names={"--sarif"}, description={"comma-separated set of path(s) to SARIF file(s) to feed to the codemods"}, split=",")
    private List<String> sarifs;
    private final DryRunTempDirCreationStrategy dryRunTempDirCreationStrategy;
    private static final int SUCCESS = 0;
    private static final int ERROR_CANT_READ_PROJECT_DIRECTORY = 1;
    private static final int ERROR_CANT_WRITE_OUTPUT_FILE = 2;
    private static final int ERROR_INVALID_ARGUMENT = 3;
    private static final List<String> defaultPathIncludes = List.of("**.java", "**/*.java", "pom.xml", "**/pom.xml", "**.jsp", "**/*.jsp", "web.xml", "**/web.xml");
    private static final List<String> defaultPathExcludes = List.of("**/test/**", "**/target/**", "**/build/**", "**/.mvn/**", ".mvn/**");
    private static final Logger log = LoggerFactory.getLogger(CLI.class);

    CLI(String[] args, List<Class<? extends CodeChanger>> codemodTypes) {
        this(args, codemodTypes, Clock.systemUTC(), new DefaultFileFinder(), new DefaultEncodingDetector(), JavaParserFactory.newFactory(), SourceDirectoryLister.createDefault(), CodeTFReportGenerator.createDefault(), new DefaultDryRunTempDirCreationStrategy());
    }

    CLI(String[] args, List<Class<? extends CodeChanger>> codemodTypes, Clock clock, FileFinder fileFinder, EncodingDetector encodingDetector, JavaParserFactory javaParserFactory, SourceDirectoryLister sourceDirectoryLister, CodeTFReportGenerator reportGenerator, DryRunTempDirCreationStrategy dryRunTempDirCreationStrategy) {
        Objects.requireNonNull(codemodTypes);
        this.codemodTypes = Collections.unmodifiableList(codemodTypes);
        this.clock = Objects.requireNonNull(clock);
        this.fileFinder = Objects.requireNonNull(fileFinder);
        this.encodingDetector = Objects.requireNonNull(encodingDetector);
        this.javaParserFactory = Objects.requireNonNull(javaParserFactory);
        this.sourceDirectoryLister = Objects.requireNonNull(sourceDirectoryLister);
        this.reportGenerator = Objects.requireNonNull(reportGenerator);
        this.args = Objects.requireNonNull(args);
        this.dryRunTempDirCreationStrategy = Objects.requireNonNull(dryRunTempDirCreationStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public Integer call() throws IOException {
        if (this.verbose) {
            LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
            context.getLogger(LoggingConfigurator.OUR_ROOT_LOGGER_NAME).setLevel(Level.DEBUG);
        }
        if (this.listCodemods) {
            for (Class clazz : this.codemodTypes) {
                Codemod annotation = clazz.getAnnotation(Codemod.class);
                log.info(annotation.id());
            }
            return 0;
        }
        if (this.output == null) {
            log.error("The output file is required");
            return 2;
        }
        if (this.projectDirectory == null) {
            log.error("No project directory specified");
            return 1;
        }
        Path outputPath = this.output.toPath();
        if (!Files.isWritable(outputPath) && !Files.isWritable(outputPath.getParent())) {
            log.error("The output file (or its parent directory) is not writable");
            return 2;
        }
        Path path = this.projectDirectory.toPath();
        if (!Files.isDirectory(path, new LinkOption[0]) || !Files.isReadable(path)) {
            log.error("The project directory is not a readable directory");
            return 1;
        }
        if (this.dryRun) {
            Path copiedProjectDirectory = this.dryRunTempDirCreationStrategy.createTempDir();
            Stopwatch watch = Stopwatch.createStarted();
            log.info("Copying project directory for dry run..: {}", (Object)copiedProjectDirectory);
            FileUtils.copyDirectory((File)this.projectDirectory, (File)copiedProjectDirectory.toFile());
            watch.stop();
            Duration elapsed = watch.elapsed();
            log.info("Copy took: {}", (Object)elapsed);
            this.projectDirectory = copiedProjectDirectory.toFile();
            Path path2 = copiedProjectDirectory;
        }
        try {
            Integer n;
            void var2_5;
            List<String> pathExcludes;
            Instant start = this.clock.instant();
            List<String> pathIncludes = this.pathIncludes;
            if (pathIncludes == null) {
                pathIncludes = defaultPathIncludes;
            }
            if ((pathExcludes = this.pathExcludes) == null) {
                pathExcludes = defaultPathExcludes;
            }
            IncludesExcludes includesExcludes = IncludesExcludes.withSettings(this.projectDirectory, pathIncludes, pathExcludes);
            List<SourceDirectory> sourceDirectories = this.sourceDirectoryLister.listJavaSourceDirectories(List.of(this.projectDirectory));
            List<Path> filePaths = this.fileFinder.findFiles((Path)var2_5, includesExcludes);
            if (this.codemodIncludes != null && this.codemodExcludes != null) {
                log.error("Codemod includes and excludes cannot both be specified");
                Integer n2 = 3;
                return n2;
            }
            CodemodRegulator regulator = this.codemodIncludes == null && this.codemodExcludes == null ? CodemodRegulator.of(DefaultRuleSetting.ENABLED, List.of()) : (this.codemodIncludes != null ? CodemodRegulator.of(DefaultRuleSetting.DISABLED, this.codemodIncludes) : CodemodRegulator.of(DefaultRuleSetting.ENABLED, this.codemodExcludes));
            List<Path> sarifFiles = this.sarifs != null ? this.sarifs.stream().map(x$0 -> Path.of(x$0, new String[0])).collect(Collectors.toList()) : List.of();
            Map<String, List<RuleSarif>> pathSarifMap = SarifParser.create().parseIntoMap(sarifFiles, (Path)var2_5);
            List<ParameterArgument> codemodParameters = this.createFromParameterStrings(this.codemodParameters);
            CodemodLoader loader = new CodemodLoader(this.codemodTypes, regulator, (Path)var2_5, pathSarifMap, codemodParameters);
            List<CodemodIdPair> codemods = loader.getCodemods();
            List<ProjectProvider> projectProviders = this.loadProjectProviders();
            List<CodeTFProvider> codeTFProviders = this.loadCodeTFProviders();
            ArrayList<CodeTFResult> results = new ArrayList<CodeTFResult>();
            JavaParser javaParser = this.javaParserFactory.create(sourceDirectories);
            CachingJavaParser cachingJavaParser = CachingJavaParser.from(javaParser);
            for (CodemodIdPair codemod : codemods) {
                DefaultCodemodExecutor codemodExecutor = new DefaultCodemodExecutor((Path)var2_5, includesExcludes, codemod, projectProviders, codeTFProviders, cachingJavaParser, this.encodingDetector);
                CodeTFResult result = codemodExecutor.execute(filePaths);
                if (result.getChangeset().isEmpty() && result.getFailedFiles().isEmpty()) continue;
                results.add(result);
            }
            Instant end = this.clock.instant();
            long elapsed = end.toEpochMilli() - start.toEpochMilli();
            if (OutputFormat.CODETF.equals((Object)this.outputFormat)) {
                CodeTFReport report = this.reportGenerator.createReport(this.projectDirectory.toPath(), String.join((CharSequence)" ", this.args), this.sarifs == null ? List.of() : this.sarifs.stream().map(x$0 -> Path.of(x$0, new String[0])).collect(Collectors.toList()), results, elapsed);
                ObjectMapper mapper = new ObjectMapper();
                mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                Files.writeString(outputPath, (CharSequence)mapper.writeValueAsString((Object)report), new OpenOption[0]);
            } else if (OutputFormat.DIFF.equals((Object)this.outputFormat)) {
                throw new UnsupportedOperationException("not supported yet");
            }
            if (this.dontExit) {
                n = -1;
                return n;
            }
            n = 0;
            return n;
        }
        finally {
            if (this.dryRun) {
                log.debug("Cleaning temp directory: {}", (Object)this.projectDirectory);
                FileUtils.deleteDirectory((File)this.projectDirectory);
            }
        }
    }

    private List<CodeTFProvider> loadCodeTFProviders() {
        ArrayList<CodeTFProvider> codeTFProviders = new ArrayList<CodeTFProvider>();
        ServiceLoader<CodeTFProvider> loader = ServiceLoader.load(CodeTFProvider.class);
        for (CodeTFProvider provider : loader) {
            codeTFProviders.add(provider);
        }
        return codeTFProviders;
    }

    private List<ProjectProvider> loadProjectProviders() {
        ArrayList<ProjectProvider> projectProviders = new ArrayList<ProjectProvider>();
        ServiceLoader<ProjectProvider> loader = ServiceLoader.load(ProjectProvider.class);
        for (ProjectProvider projectProvider : loader) {
            projectProviders.add(projectProvider);
        }
        return projectProviders;
    }

    private List<ParameterArgument> createFromParameterStrings(List<String> parameterStrings) {
        if (parameterStrings == null || parameterStrings.isEmpty()) {
            return List.of();
        }
        return parameterStrings.stream().map(ParameterArgument::fromNameValuePairs).toList();
    }

    @VisibleForTesting
    static class DefaultFileFinder
    implements FileFinder {
        DefaultFileFinder() {
        }

        @Override
        public List<Path> findFiles(Path projectDir, IncludesExcludes includesExcludes) {
            List<Path> allFiles;
            try (Stream<Path> paths = Files.walk(projectDir, new FileVisitOption[0]);){
                allFiles = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> !Files.isSymbolicLink(p)).filter(p -> includesExcludes.shouldInspect(p.toFile())).sorted().toList();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return allFiles;
        }
    }

    private static class DefaultDryRunTempDirCreationStrategy
    implements DryRunTempDirCreationStrategy {
        private DefaultDryRunTempDirCreationStrategy() {
        }

        @Override
        public Path createTempDir() throws IOException {
            return Files.createTempDirectory("codemodder-project", new FileAttribute[0]);
        }
    }

    @VisibleForTesting
    static interface DryRunTempDirCreationStrategy {
        public Path createTempDir() throws IOException;
    }

    static enum OutputFormat {
        CODETF,
        DIFF;

    }
}

