package io.burkard.cdk.services.elasticloadbalancingv2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnTargetGroupProps {

  def apply(
    unhealthyThresholdCount: Option[Number] = None,
    protocolVersion: Option[String] = None,
    healthCheckTimeoutSeconds: Option[Number] = None,
    healthCheckIntervalSeconds: Option[Number] = None,
    name: Option[String] = None,
    targets: Option[List[_]] = None,
    healthCheckProtocol: Option[String] = None,
    vpcId: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    healthyThresholdCount: Option[Number] = None,
    matcher: Option[software.amazon.awscdk.services.elasticloadbalancingv2.CfnTargetGroup.MatcherProperty] = None,
    port: Option[Number] = None,
    healthCheckPath: Option[String] = None,
    healthCheckPort: Option[String] = None,
    healthCheckEnabled: Option[Boolean] = None,
    ipAddressType: Option[String] = None,
    targetGroupAttributes: Option[List[_]] = None,
    targetType: Option[String] = None,
    protocol: Option[String] = None
  ): software.amazon.awscdk.services.elasticloadbalancingv2.CfnTargetGroupProps =
    (new software.amazon.awscdk.services.elasticloadbalancingv2.CfnTargetGroupProps.Builder)
      .unhealthyThresholdCount(unhealthyThresholdCount.orNull)
      .protocolVersion(protocolVersion.orNull)
      .healthCheckTimeoutSeconds(healthCheckTimeoutSeconds.orNull)
      .healthCheckIntervalSeconds(healthCheckIntervalSeconds.orNull)
      .name(name.orNull)
      .targets(targets.map(_.asJava).orNull)
      .healthCheckProtocol(healthCheckProtocol.orNull)
      .vpcId(vpcId.orNull)
      .tags(tags.map(_.asJava).orNull)
      .healthyThresholdCount(healthyThresholdCount.orNull)
      .matcher(matcher.orNull)
      .port(port.orNull)
      .healthCheckPath(healthCheckPath.orNull)
      .healthCheckPort(healthCheckPort.orNull)
      .healthCheckEnabled(healthCheckEnabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .ipAddressType(ipAddressType.orNull)
      .targetGroupAttributes(targetGroupAttributes.map(_.asJava).orNull)
      .targetType(targetType.orNull)
      .protocol(protocol.orNull)
      .build()
}
