package io.burkard.cdk.services.backup

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object FrameworkControlProperty {

  def apply(
    controlName: String,
    controlInputParameters: Option[List[_]] = None,
    controlScope: Option[AnyRef] = None
  ): software.amazon.awscdk.services.backup.CfnFramework.FrameworkControlProperty =
    (new software.amazon.awscdk.services.backup.CfnFramework.FrameworkControlProperty.Builder)
      .controlName(controlName)
      .controlInputParameters(controlInputParameters.map(_.asJava).orNull)
      .controlScope(controlScope.orNull)
      .build()
}
