/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.inject.aspect;

import io.avaje.inject.aop.Invocation;
import io.avaje.inject.aop.MethodInterceptor;
import io.avaje.validation.adapter.ValidationAdapter;
import io.avaje.validation.adapter.ValidationContext;
import io.avaje.validation.adapter.ValidationRequest;
import io.avaje.validation.inject.aspect.MethodAdapterProvider;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.Map;

final class ParamInterceptor
implements MethodInterceptor {
    private List<ValidationAdapter<Object>> paramValidationAdapter;
    private ValidationAdapter<Object> returnValidationAdapter;
    private ValidationContext ctx;
    private final Locale locale;
    private final boolean throwOnParamFailure;
    private final Method method;

    public ParamInterceptor(Locale locale, Method method, boolean throwOnParamFailure) {
        this.locale = locale;
        this.throwOnParamFailure = throwOnParamFailure;
        this.method = method;
    }

    public void invoke(Invocation invocation) throws Throwable {
        Object[] args = invocation.arguments();
        ValidationRequest req = this.ctx.request(this.locale, List.of());
        int i = 0;
        for (ValidationAdapter<Object> adapter : this.paramValidationAdapter) {
            Object object = args[i];
            adapter.validate(object, req);
            ++i;
        }
        if (this.throwOnParamFailure) {
            req.throwWithViolations();
        }
        this.returnValidationAdapter.validate(invocation.invoke(), req);
        req.throwWithViolations();
    }

    public void postConstruct(ValidationContext ctx, Map<Method, MethodAdapterProvider> providerMap) {
        MethodAdapterProvider methodAdapterProvider = providerMap.get(this.method);
        this.ctx = ctx;
        this.paramValidationAdapter = methodAdapterProvider.paramAdapters(ctx);
        this.returnValidationAdapter = methodAdapterProvider.returnAdapter(ctx);
    }
}

