/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.spi.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

final class ServiceProviderPrism {
    private final List<TypeMirror> _value;
    public static final String PRISM_TYPE = "io.avaje.spi.ServiceProvider";
    private final Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
    private final Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);

    static ServiceProviderPrism getInstanceOn(Element element) {
        AnnotationMirror mirror = ServiceProviderPrism.getMirror(element);
        if (mirror == null) {
            return null;
        }
        return ServiceProviderPrism.getInstance(mirror);
    }

    static Optional<ServiceProviderPrism> getOptionalOn(Element element) {
        AnnotationMirror mirror = ServiceProviderPrism.getMirror(element);
        if (mirror == null) {
            return Optional.empty();
        }
        return ServiceProviderPrism.getOptional(mirror);
    }

    static ServiceProviderPrism getInstance(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return null;
        }
        return new ServiceProviderPrism(mirror);
    }

    static Optional<ServiceProviderPrism> getOptional(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return Optional.empty();
        }
        return Optional.of(new ServiceProviderPrism(mirror));
    }

    private ServiceProviderPrism(AnnotationMirror mirror) {
        for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
            this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
        }
        this._value = this.getArrayValues("value", TypeMirror.class);
    }

    public List<TypeMirror> value() {
        return this._value;
    }

    private <T> List<T> getArrayValues(String name, Class<T> clazz) {
        return ServiceProviderPrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
    }

    private static AnnotationMirror getMirror(Element target) {
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!PRISM_TYPE.contentEquals(mfqn)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static <T> List<T> getArrayValues(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return List.of();
        }
        if (av.getValue() instanceof List) {
            ArrayList<T> result = new ArrayList<T>();
            for (AnnotationValue v : ServiceProviderPrism.getValueAsList(av)) {
                if (clazz.isInstance(v.getValue())) {
                    result.add(clazz.cast(v.getValue()));
                    continue;
                }
                return List.of();
            }
            return result;
        }
        return List.of();
    }

    private static List<AnnotationValue> getValueAsList(AnnotationValue av) {
        return (List)av.getValue();
    }

    static final class Values {
        private final Map<String, AnnotationValue> values;

        private Values(Map<String, AnnotationValue> values) {
            this.values = values;
        }

        AnnotationValue value() {
            return this.values.get("value");
        }
    }
}

