package io.avaje.spi.internal;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;

import javax.lang.model.element.ModuleElement;

final class PomPluginWriter {

  private static final String PLUGIN =
      "  <!-- generated by avaje spi service -->\n"
          + "      <plugin>\n"
          + "        <groupId>io.avaje</groupId>\n"
          + "        <artifactId>avaje-provides-maven-plugin</artifactId>\n"
          + "        <version>2.3</version>\n"
          + "        <executions>\n"
          + "          <execution>\n"
          + "            <?m2e execute onIncremental?>\n"
          + "            <!-- Will transform compiled module-info to add missing spi provides -->"
          + "            <goals>\n"
          + "              <goal>disable-apt-validation</goal>\n"
          + "              <goal>add-module-spi</goal>\n"
          + "            </goals>\n"
          + "          </execution>\n"
          + "        </executions>\n"
          + "      </plugin>\n"
          + "    ";

  static void addPlugin2Pom() throws IOException {
    var module = APContext.getProjectModuleElement();
    // don't need mvn plugin if not using JPMS
    if (disabledOrNotUsingModulePath(module)) {
      return;
    }

    var pomPath = APContext.getBuildResource("").getParent().resolve("pom.xml");
    if (!pomPath.toFile().exists()) {
      return;
    }

    var pomContent = Files.readString(pomPath);
    // if not already present in pom.xml
    if (pomContent.contains("avaje-provides-maven-plugin")) {
      return;
    }
    APContext.logNote("Adding avaje-provides-maven-plugin to pom");
    var pluginsIndex = pomContent.indexOf("</plugins>");
    var builder = new StringBuilder(pomContent);
    if (pluginsIndex != -1) {
      builder.insert(pluginsIndex, PLUGIN);

      Files.writeString(
          pomPath, builder.toString(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
    }
  }

  private static boolean disabledOrNotUsingModulePath(ModuleElement module) {
    return APContext.jdkVersion() < 24
        || !APContext.getOption("buildPlugin").map(Boolean::valueOf).orElse(true)
        || module == null || module.isUnnamed();
  }
}
