/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.spi.internal;

import io.avaje.spi.internal.APContext;
import io.avaje.spi.internal.ModuleReader;
import io.avaje.spi.internal.ServicePrism;
import io.avaje.spi.internal.ServiceProviderPrism;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"io.avaje.spi.ServiceProvider"})
public class ServiceProcessor
extends AbstractProcessor {
    private final Map<String, Set<String>> services = new ConcurrentHashMap<String, Set<String>>();
    private Elements elements;
    private Types types;
    private ModuleElement moduleElement;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        this.elements = env.getElementUtils();
        this.types = env.getTypeUtils();
        APContext.init(env);
    }

    @Override
    public boolean process(Set<? extends TypeElement> tes, RoundEnvironment roundEnv) {
        Set<? extends Element> annotated = roundEnv.getElementsAnnotatedWith(APContext.typeElement("io.avaje.spi.ServiceProvider"));
        for (TypeElement type : ElementFilter.typesIn(annotated)) {
            this.validate(type);
            List<TypeElement> contracts = this.getServiceInterfaces(type);
            if (contracts.isEmpty()) {
                APContext.logError(type, "Service Providers must implement an SPI interface", new Object[0]);
            }
            for (TypeElement contract : contracts) {
                String cn = this.elements.getBinaryName(contract).toString();
                Set v = this.services.computeIfAbsent(cn, k -> new TreeSet());
                v.add(this.elements.getBinaryName(type).toString());
            }
        }
        this.findModule(tes, roundEnv);
        if (roundEnv.processingOver()) {
            this.write();
            this.validateModule();
        }
        return false;
    }

    private void validate(TypeElement type) {
        boolean noPublicConstructor;
        Set<Modifier> mods = type.getModifiers();
        if (!mods.contains((Object)Modifier.PUBLIC) || type.getEnclosingElement().getKind() == ElementKind.CLASS && !mods.contains((Object)Modifier.STATIC)) {
            APContext.logError(type, "A Service Provider must be a public class or a public static nested class", new Object[0]);
        }
        if (noPublicConstructor = ElementFilter.constructorsIn(type.getEnclosedElements()).stream().filter(e -> e.getParameters().isEmpty()).filter(e -> e.getModifiers().contains((Object)Modifier.PUBLIC)).findAny().isEmpty()) {
            APContext.logError(type, "A Service Provider must have a public no-args constructor", new Object[0]);
        }
    }

    private void write() {
        Closeable file2;
        String contract;
        Filer filer = this.processingEnv.getFiler();
        for (Map.Entry<String, Set<String>> e : this.services.entrySet()) {
            contract = e.getKey();
            try {
                file2 = filer.getResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/" + contract).openInputStream();
                try (BufferedReader buffer = new BufferedReader(new InputStreamReader((InputStream)file2, StandardCharsets.UTF_8));){
                    String line;
                    while ((line = buffer.readLine()) != null) {
                        e.getValue().add(line);
                    }
                }
                finally {
                    if (file2 == null) continue;
                    ((InputStream)file2).close();
                }
            }
            catch (FileNotFoundException | NoSuchFileException file2) {
            }
            catch (IOException x) {
                APContext.logError("Failed to load existing service definition file. SPI: " + contract + " exception: " + String.valueOf(x), new Object[0]);
            }
        }
        for (Map.Entry<String, Set<String>> e : this.services.entrySet()) {
            contract = e.getKey();
            APContext.logNote("Writing META-INF/services/%s", contract);
            try {
                file2 = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/" + contract, new Element[0]).openOutputStream();
                try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)file2, StandardCharsets.UTF_8));){
                    for (String value : e.getValue()) {
                        pw.println(value);
                    }
                }
                finally {
                    if (file2 == null) continue;
                    ((OutputStream)file2).close();
                }
            }
            catch (IOException x) {
                APContext.logError("Failed to write service definition files: %s", x);
            }
        }
    }

    private List<TypeElement> getServiceInterfaces(TypeElement type) {
        boolean hasInterfaces;
        ArrayList<TypeElement> typeElementList = new ArrayList<TypeElement>();
        List<TypeMirror> spis = ServiceProviderPrism.getInstanceOn(type).value();
        List<? extends TypeMirror> interfaces = type.getInterfaces();
        boolean hasBaseClass = type.getSuperclass().getKind() != TypeKind.NONE && !this.isObject(type.getSuperclass());
        boolean bl = hasInterfaces = !interfaces.isEmpty();
        if (spis.isEmpty()) {
            if (this.checkSPI(type.asType(), typeElementList)) {
                return typeElementList;
            }
            if (hasBaseClass ^ hasInterfaces) {
                if (hasBaseClass) {
                    typeElementList.add(APContext.asTypeElement(type.getSuperclass()));
                } else {
                    typeElementList.add(APContext.asTypeElement(type.getInterfaces().get(0)));
                }
            } else {
                APContext.logError(type, "SPI type was not specified, and could not be inferred.", new Object[0]);
            }
            return typeElementList;
        }
        for (TypeMirror spiMirror : spis) {
            if (!hasInterfaces && !hasBaseClass || !this.isAssignable2Interface(type, spiMirror)) {
                APContext.logError(type, "Service Provider does not extend %s", spiMirror);
                continue;
            }
            if (spiMirror instanceof DeclaredType) {
                typeElementList.add(APContext.asTypeElement(spiMirror));
                continue;
            }
            APContext.logError(type, "Invalid type specified as the Service Provider Interface", new Object[0]);
        }
        return typeElementList;
    }

    private boolean checkSPI(TypeMirror typeMirror, List<TypeElement> typeElementList) {
        TypeElement type = APContext.asTypeElement(typeMirror);
        if (type == null) {
            return false;
        }
        if (ServicePrism.isPresent(type)) {
            typeElementList.add(type);
            return true;
        }
        ArrayList<? extends TypeMirror> supers = new ArrayList<TypeMirror>();
        supers.add(type.getSuperclass());
        supers.addAll(type.getInterfaces());
        for (TypeMirror typeMirror2 : supers) {
            if (!this.checkSPI(typeMirror2, typeElementList)) continue;
            return true;
        }
        return false;
    }

    private boolean isObject(TypeMirror t) {
        if (t instanceof DeclaredType) {
            return "java.lang.Object".equals(APContext.asTypeElement(t).getQualifiedName().toString());
        }
        return false;
    }

    private boolean isAssignable2Interface(Element type, TypeMirror superType) {
        return Optional.ofNullable(type).stream().flatMap(this::superTypes).anyMatch(superType.toString()::equals);
    }

    private Stream<String> superTypes(Element element) {
        return this.types.directSupertypes(element.asType()).stream().filter(type -> !type.toString().contains("java.lang.Object")).map(superType -> (TypeElement)this.types.asElement((TypeMirror)superType)).flatMap(e -> Stream.concat(this.superTypes((Element)e), Stream.of(e))).map(Object::toString);
    }

    ModuleElement findModule(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.moduleElement == null) {
            this.moduleElement = annotations.stream().map(roundEnv::getElementsAnnotatedWith).flatMap(Collection::stream).findAny().map(this::getModuleElement).orElseThrow();
        }
        return this.moduleElement;
    }

    ModuleElement getModuleElement(Element e) {
        if (e == null || e instanceof ModuleElement) {
            return (ModuleElement)e;
        }
        return this.getModuleElement(e.getEnclosingElement());
    }

    void validateModule() {
        if (this.moduleElement != null && !this.moduleElement.isUnnamed()) {
            ModuleReader moduleReader = new ModuleReader(this.services);
            try (BufferedReader reader = APContext.getModuleInfoReader();){
                moduleReader.read(reader, this.moduleElement);
                if (moduleReader.staticWarning()) {
                    APContext.logError(this.moduleElement, "`requires io.avaje.spi` should be `requires static io.avaje.spi;`", new Object[0]);
                }
                if (moduleReader.coreWarning()) {
                    APContext.logWarn(this.moduleElement, "io.avaje.spi.core should not be used directly", new Object[0]);
                }
                if (!ServiceProcessor.buildPluginAvailable()) {
                    this.logModuleError(moduleReader);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void logModuleError(ModuleReader moduleReader) {
        Map<String, String> shortQualifiedMap = this.services.keySet().stream().collect(Collectors.toMap(s -> s.replace("$", "."), s -> s));
        moduleReader.missing().forEach((k, v) -> {
            if (!v.isEmpty()) {
                APContext.logError(this.moduleElement, "Missing `provides %s with %s;`", k, String.join((CharSequence)", ", (Iterable<? extends CharSequence>)this.services.get(shortQualifiedMap.get(k))));
            }
        });
    }

    private static boolean buildPluginAvailable() {
        return ServiceProcessor.resource("target/avaje-plugin-exists.txt", "/target/classes") || ServiceProcessor.resource("build/avaje-plugin-exists.txt", "/build/classes/java/main");
    }

    private static boolean resource(String relativeName, String replace) {
        boolean bl;
        block8: {
            InputStream inputStream = new URI(APContext.filer().getResource(StandardLocation.CLASS_OUTPUT, "", relativeName).toUri().toString().replace(replace, "")).toURL().openStream();
            try {
                boolean bl2 = bl = inputStream.available() > 0;
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | URISyntaxException e) {
                    return false;
                }
            }
            inputStream.close();
        }
        return bl;
    }
}

