/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.metrics.statsd;

import com.timgroup.statsd.NonBlockingStatsDClientBuilder;
import com.timgroup.statsd.StatsDClient;
import io.avaje.metrics.MetricRegistry;
import io.avaje.metrics.Metrics;
import io.avaje.metrics.statsd.DatabaseReporter;
import io.avaje.metrics.statsd.Reporter;
import io.avaje.metrics.statsd.StatsdReporter;
import io.ebean.Database;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

final class StatsdBuilder
implements StatsdReporter.Builder {
    private final List<StatsdReporter.Reporter> reporters = new ArrayList<StatsdReporter.Reporter>();
    private MetricRegistry registry;
    private String hostname = "localhost";
    private int port = 8125;
    private StatsDClient client;
    private long timedThresholdMicros;
    private String[] tags;
    private int schedule = 60;
    private TimeUnit scheduleTimeUnit = TimeUnit.SECONDS;

    StatsdBuilder() {
    }

    @Override
    public StatsdReporter.Builder hostname(String hostname) {
        this.hostname = Objects.requireNonNull(hostname);
        return this;
    }

    @Override
    public StatsdReporter.Builder port(int port) {
        this.port = port;
        return this;
    }

    @Override
    public StatsdReporter.Builder client(StatsDClient client) {
        this.client = client;
        return this;
    }

    @Override
    public StatsdReporter.Builder timedThresholdMicros(long timedThresholdMicros) {
        this.timedThresholdMicros = timedThresholdMicros;
        return this;
    }

    @Override
    public StatsdReporter.Builder tags(String[] tags) {
        this.tags = tags;
        return this;
    }

    @Override
    public StatsdReporter.Builder schedule(int schedule, TimeUnit timeUnit) {
        this.schedule = schedule;
        this.scheduleTimeUnit = Objects.requireNonNull(timeUnit);
        return this;
    }

    @Override
    public StatsdReporter.Builder registry(MetricRegistry registry) {
        this.registry = Objects.requireNonNull(registry);
        return this;
    }

    @Override
    public StatsdReporter.Builder database(Database database) {
        this.reporters.add(DatabaseReporter.reporter(database, false));
        return this;
    }

    @Override
    public StatsdReporter.Builder databaseVerbose(Database database) {
        this.reporters.add(DatabaseReporter.reporter(database, true));
        return this;
    }

    @Override
    public StatsdReporter.Builder reporter(StatsdReporter.Reporter reporter) {
        this.reporters.add(Objects.requireNonNull(reporter));
        return this;
    }

    @Override
    public Reporter build() {
        if (this.registry == null) {
            this.registry = Metrics.registry();
        }
        if (this.client == null) {
            this.client = new NonBlockingStatsDClientBuilder().hostname(Objects.requireNonNull(this.hostname)).port(this.port).constantTags(this.tags).build();
        }
        return new Reporter(this.registry, this.client, this.timedThresholdMicros, this.schedule, this.scheduleTimeUnit, this.reporters);
    }
}

