/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.metrics.statsd;

import com.timgroup.statsd.StatsDClient;
import io.avaje.metrics.Counter;
import io.avaje.metrics.GaugeDouble;
import io.avaje.metrics.GaugeLong;
import io.avaje.metrics.Meter;
import io.avaje.metrics.Metric;
import io.avaje.metrics.MetricRegistry;
import io.avaje.metrics.ScheduledTask;
import io.avaje.metrics.Timer;
import io.avaje.metrics.statsd.StatsdReporter;
import io.avaje.metrics.statsd.Trim;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class Reporter
implements Runnable,
AutoCloseable,
StatsdReporter {
    private final MetricRegistry registry;
    private final StatsDClient client;
    private final long timedThreshold;
    private final List<StatsdReporter.Reporter> reporters;
    private final ScheduledTask scheduledTask;
    private final AtomicBoolean started = new AtomicBoolean(false);

    Reporter(MetricRegistry registry, StatsDClient client, long timedThreshold, int schedule, TimeUnit scheduleTimeUnit, List<StatsdReporter.Reporter> reporters) {
        this.registry = registry;
        this.client = client;
        this.timedThreshold = timedThreshold;
        this.reporters = reporters;
        this.scheduledTask = ScheduledTask.builder().schedule(schedule, schedule, scheduleTimeUnit).task((Runnable)this).build();
    }

    @Override
    public void start() {
        this.scheduledTask.start();
        this.started.set(true);
    }

    @Override
    public void close() {
        if (this.started.get()) {
            this.scheduledTask.cancel(true);
        }
    }

    @Override
    public void run() {
        AvajeMetricsVisitor visitor = new AvajeMetricsVisitor();
        for (Metric.Statistics metric : this.registry.collectMetrics()) {
            metric.visit((Metric.Visitor)visitor);
        }
        for (StatsdReporter.Reporter reporter : this.reporters) {
            reporter.report(this.client);
        }
    }

    private final class AvajeMetricsVisitor
    implements Metric.Visitor {
        private final long epochSecs = System.currentTimeMillis() / 1000L;

        private AvajeMetricsVisitor() {
        }

        private void sendValues(Meter.Stats stats, String name, String ... tags) {
            if (stats.count() > 0L) {
                Reporter.this.client.countWithTimestamp(name + ".count", stats.count(), this.epochSecs, tags);
                Reporter.this.client.gaugeWithTimestamp(name + ".total", stats.total(), this.epochSecs, tags);
                Reporter.this.client.gaugeWithTimestamp(name + ".mean", stats.mean(), this.epochSecs, tags);
                Reporter.this.client.gaugeWithTimestamp(name + ".max", stats.max(), this.epochSecs, tags);
            }
        }

        public void visit(Timer.Stats timed) {
            if (Reporter.this.timedThreshold == 0L || Reporter.this.timedThreshold < timed.total()) {
                if (timed.name().startsWith("web.api.")) {
                    String labelTag = "label:" + Trim.trim(timed.name(), 8);
                    this.sendValues((Meter.Stats)timed, "web.api", timed.id().tags().append(new String[]{labelTag}));
                } else if (timed.name().startsWith("app.")) {
                    String labelTag = "label:" + Trim.trim(timed.name(), 4);
                    this.sendValues((Meter.Stats)timed, "app.component", timed.id().tags().append(new String[]{labelTag}));
                } else {
                    this.sendValues((Meter.Stats)timed, timed.name(), timed.tags());
                }
            }
        }

        public void visit(Meter.Stats stats) {
            this.sendValues(stats, stats.name(), stats.tags());
        }

        public void visit(Counter.Stats counter) {
            Reporter.this.client.countWithTimestamp(counter.name(), counter.count(), this.epochSecs, counter.tags());
        }

        public void visit(GaugeDouble.Stats gauge) {
            Reporter.this.client.gaugeWithTimestamp(gauge.name(), gauge.value(), this.epochSecs, gauge.tags());
        }

        public void visit(GaugeLong.Stats gauge) {
            Reporter.this.client.gaugeWithTimestamp(gauge.name(), gauge.value(), this.epochSecs, gauge.tags());
        }
    }
}

