/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.metrics.statsd;

import com.timgroup.statsd.StatsDClient;
import io.avaje.metrics.statsd.StatsdReporter;
import io.avaje.metrics.statsd.Trim;
import io.ebean.Database;
import io.ebean.datasource.DataSourcePool;
import io.ebean.datasource.PoolStatus;
import io.ebean.meta.MetaCountMetric;
import io.ebean.meta.MetaQueryMetric;
import io.ebean.meta.MetaTimedMetric;
import io.ebean.meta.ServerMetrics;
import javax.sql.DataSource;

final class DatabaseReporter
implements StatsdReporter.Reporter {
    private final Database database;
    private final boolean verbose;

    private DatabaseReporter(Database database, boolean verbose) {
        this.database = database;
        this.verbose = verbose;
    }

    static StatsdReporter.Reporter reporter(Database database, boolean verbose) {
        return new DatabaseReporter(database, verbose);
    }

    @Override
    public void report(StatsDClient sender) {
        new DReport(this.database, sender, this.verbose).report();
    }

    private static final class DReport {
        private final StatsDClient reporter;
        private final ServerMetrics dbMetrics;
        private final long epochSecs;
        private final String dbTag;

        private DReport(Database database, StatsDClient reporter, boolean verbose) {
            DataSource readDatasource;
            this.reporter = reporter;
            this.dbTag = "db:" + database.name();
            this.dbMetrics = database.metaInfo().collectMetrics();
            this.epochSecs = System.currentTimeMillis() / 1000L;
            DataSource dataSource = database.dataSource();
            if (dataSource instanceof DataSourcePool) {
                DataSourcePool pool = (DataSourcePool)dataSource;
                this.poolMetrics(verbose, pool, "type:main");
            }
            if ((readDatasource = database.readOnlyDataSource()) instanceof DataSourcePool && readDatasource != dataSource) {
                DataSourcePool readOnlyPool = (DataSourcePool)readDatasource;
                this.poolMetrics(verbose, readOnlyPool, "type:readonly");
            }
        }

        private void poolMetrics(boolean verbose, DataSourcePool pool, String tag) {
            if (verbose) {
                this.poolMetrics(pool, tag);
            } else {
                this.reporter.gaugeWithTimestamp("datasource.pool.size", (long)pool.size(), this.epochSecs, new String[]{this.dbTag, tag});
            }
        }

        private void poolMetrics(DataSourcePool pool, String tag) {
            long waitMicros;
            PoolStatus status = pool.status(true);
            int size = status.busy() + status.free();
            this.reporter.gaugeWithTimestamp("datasource.pool.size", (long)size, this.epochSecs, new String[]{this.dbTag, tag});
            long meanAcquireMicros = status.meanAcquireNanos() / 1000L;
            this.reporter.gaugeWithTimestamp("datasource.pool.meanAcquireMicros", meanAcquireMicros, this.epochSecs, new String[]{this.dbTag, tag});
            this.reporter.gaugeWithTimestamp("datasource.pool.usageCount", (long)status.hitCount(), this.epochSecs, new String[]{this.dbTag, tag});
            this.reporter.gaugeWithTimestamp("datasource.pool.acquireMicros", status.totalAcquireMicros(), this.epochSecs, new String[]{this.dbTag, tag});
            int waitCount = status.waitCount();
            if (waitCount > 0) {
                this.reporter.gaugeWithTimestamp("datasource.pool.waitCount", (long)waitCount, this.epochSecs, new String[]{this.dbTag, tag});
            }
            if ((waitMicros = status.totalWaitMicros()) > 0L) {
                this.reporter.gaugeWithTimestamp("datasource.pool.waitMicros", waitMicros, this.epochSecs, new String[]{this.dbTag, tag});
            }
        }

        private void report() {
            for (MetaTimedMetric timedMetric : this.dbMetrics.timedMetrics()) {
                this.reportTimedMetric(timedMetric);
            }
            for (MetaQueryMetric queryMetric : this.dbMetrics.queryMetrics()) {
                this.reportQueryMetric(queryMetric);
            }
            for (MetaCountMetric countMetric : this.dbMetrics.countMetrics()) {
                this.reportCountMetric(countMetric);
            }
        }

        private void reportCountMetric(MetaCountMetric countMetric) {
            this.reporter.count(this.nm("ebean.count.", countMetric.name()), countMetric.count(), new String[]{this.dbTag});
        }

        private void reportTimedMetric(MetaTimedMetric metric) {
            String name = metric.name();
            if (name.startsWith("txn.")) {
                this.reportMetric(metric, "ebean.txn", this.dbTag, "label:" + Trim.qry(name));
            } else {
                this.reportMetric(metric, this.nm("ebean.timed.", name), this.dbTag);
            }
        }

        private void reportQueryMetric(MetaQueryMetric metric) {
            String name = metric.name();
            String queryTag = "label:" + Trim.qry(name);
            if (name.startsWith("orm")) {
                this.reportMetric((MetaTimedMetric)metric, "ebean.query", this.dbTag, "type:orm", queryTag);
            } else if (name.startsWith("sql")) {
                this.reportMetric((MetaTimedMetric)metric, "ebean.query", this.dbTag, "type:sql", queryTag);
            } else {
                this.reportMetric((MetaTimedMetric)metric, "ebean.query", this.dbTag, "type:other", queryTag);
            }
        }

        private void reportMetric(MetaTimedMetric metric, String name, String ... tags) {
            this.reporter.countWithTimestamp(this.nm(name, ".count"), metric.count(), this.epochSecs, tags);
            this.reporter.gaugeWithTimestamp(this.nm(name, ".max"), metric.max(), this.epochSecs, tags);
            this.reporter.gaugeWithTimestamp(this.nm(name, ".mean"), metric.mean(), this.epochSecs, tags);
            this.reporter.gaugeWithTimestamp(this.nm(name, ".total"), metric.total(), this.epochSecs, tags);
        }

        private String nm(String name, String suffix) {
            return name + suffix;
        }
    }
}

